/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jumpboat.mixin;

import cy.jdkdigital.jumpboat.Config;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Boat.class})
public abstract class MixinBoat
extends Entity
implements PlayerRideableJumping {
    @Shadow(remap=false)
    private Boat.Status status;
    private boolean hasJumpedFromWater;

    public MixinBoat(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void onPlayerJump(int boostLevel) {
        if (this.status == Boat.Status.IN_WATER) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (Double)Config.GENERAL.jumpHeightInWater.get() * (double)boostLevel / 100.0, 0.0));
            this.hasJumpedFromWater = true;
        } else if (this.status == Boat.Status.ON_LAND) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (Double)Config.GENERAL.jumpHeightOnLand.get() * (double)boostLevel / 100.0, 0.0));
        }
    }

    public boolean canJump() {
        return true;
    }

    public void handleStartJump(int p_184775_1_) {
        if (this.hasJumpedFromWater) {
            this.playSound(SoundEvents.PLAYER_SPLASH, 0.4f, 1.0f);
            this.hasJumpedFromWater = false;
        }
    }

    public void handleStopJump() {
    }
}

