/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data.client;

import com.Pdiddy973.AllTheCompressed.AllTheCompressed;
import com.Pdiddy973.AllTheCompressed.ModRegistry;
import com.Pdiddy973.AllTheCompressed.overlay.Overlays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(PackOutput packOutput, ExistingFileHelper fileHelper) {
        super(packOutput, "allthecompressed", fileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlockWithItem((Supplier<Block>)ModRegistry.FLINT_BLOCK);
        this.columnBlockWithItem(ModRegistry.BLAZE_ROD_BLOCK);
        this.simpleBlockWithItem((Supplier<Block>)ModRegistry.ANTIMATTER_BLOCK);
        ModelFile.ExistingModelFile defaultBlock = this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/block"));
        Set<Overlays> removeTrailingBlock = Set.of(Overlays.MAGMA, Overlays.DRIED_KELP, Overlays.SNOW, Overlays.WAX);
        Set<Overlays> columnBlocks = Set.of(Overlays.MELON, Overlays.PUMPKIN, Overlays.QUARTZ);
        Set<Overlays> bottomTopBlocks = Set.of(Overlays.DRIED_KELP, Overlays.GRASS, Overlays.HONEY, Overlays.PODZOL, Overlays.MYCELIUM);
        Set<Overlays> xychorium = Set.of(Overlays.BLUE_XYCHORIUM, Overlays.DARK_XYCHORIUM, Overlays.GREEN_XYCHORIUM, Overlays.LIGHT_XYCHORIUM, Overlays.RED_XYCHORIUM);
        for (Overlays value : Overlays.values()) {
            ResourceLocation parent = value.overlay.parent;
            Optional block = BuiltInRegistries.BLOCK.getOptional(parent);
            if (block.isEmpty() || block.get() == Blocks.AIR) {
                AllTheCompressed.LOGGER.error("missing block during datagen: {}", (Object)parent);
                continue;
            }
            if (xychorium.contains((Object)value)) continue;
            for (int i = 0; i < 9; ++i) {
                DeferredBlock<Block> each = value.overlay.xall.get(i);
                String path = each.getId().getPath();
                BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(path);
                String texture = this.blockTexture(parent).toString();
                if (removeTrailingBlock.contains((Object)value)) {
                    texture = texture.substring(0, texture.lastIndexOf("_block"));
                }
                if (block.get() instanceof RotatedPillarBlock || columnBlocks.contains((Object)value)) {
                    boolean isLog;
                    model.element().allFaces((direction, faceBuilder) -> {
                        if (direction == Direction.UP || direction == Direction.DOWN) {
                            faceBuilder.texture("#end");
                        } else {
                            faceBuilder.texture("#side");
                        }
                        faceBuilder.cullface(direction);
                    });
                    boolean bl = isLog = parent.getPath().endsWith("_log") || parent.getPath().endsWith("_log_0") || parent.getPath().equals("deepslate");
                    if (isLog) {
                        model.texture("end", texture.concat("_top"));
                        model.texture("side", texture);
                    } else {
                        model.texture("end", texture.concat("_top"));
                        model.texture("side", texture.concat("_side"));
                    }
                } else if (bottomTopBlocks.contains((Object)value)) {
                    model.element().allFaces((direction, faceBuilder) -> {
                        if (direction == Direction.UP) {
                            faceBuilder.texture("#top");
                        } else if (direction == Direction.DOWN) {
                            faceBuilder.texture("#bottom");
                        } else {
                            faceBuilder.texture("#side");
                        }
                        faceBuilder.cullface(direction);
                    });
                    if (value == Overlays.GRASS) {
                        model.texture("bottom", "minecraft:block/dirt");
                        model.texture("side", "minecraft:block/grass_block_side");
                        model.texture("top", "allthecompressed:block/grass_block_top");
                    } else if (value == Overlays.PODZOL || value == Overlays.MYCELIUM) {
                        model.texture("bottom", "minecraft:block/dirt");
                        model.texture("side", texture.concat("_side"));
                        model.texture("top", texture.concat("_top"));
                    } else {
                        model.texture("bottom", texture.concat("_bottom"));
                        model.texture("side", texture.concat("_side"));
                        model.texture("top", texture.concat("_top"));
                    }
                } else {
                    model.element().cube("#all");
                    model.texture("all", texture);
                }
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().cube("#overlay").end()).renderType("minecraft:cutout")).texture("overlay", String.format("%s:block/layer_%s", "allthecompressed", i + 1))).texture("particle", "minecraft:block/netherite_block")).parent((ModelFile)defaultBlock);
                this.simpleBlockWithItem((Block)each.get(), (ModelFile)model);
            }
        }
    }

    public void simpleBlockWithItem(Supplier<Block> block) {
        super.simpleBlockWithItem(block.get(), this.cubeAll(block.get()));
    }

    public void columnBlockWithItem(DeferredBlock<Block> block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get()));
        ModelBuilder modelFile = this.models().cubeColumn(key.getPath(), this.blockTexture(key), this.blockTexture(key, "end"));
        super.simpleBlockWithItem((Block)block.get(), (ModelFile)modelFile);
    }

    public ResourceLocation blockTexture(ResourceLocation key) {
        return ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)String.format("block/%s", key.getPath()));
    }

    public ResourceLocation blockTexture(ResourceLocation key, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)String.format("block/%s_%s", key.getPath(), suffix));
    }
}

