/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data.server;

import com.Pdiddy973.AllTheCompressed.AllTheCompressed;
import com.Pdiddy973.AllTheCompressed.ModRegistry;
import com.Pdiddy973.AllTheCompressed.data.compat.EnergizingRecipeBuilder;
import com.Pdiddy973.AllTheCompressed.overlay.Overlays;
import com.Pdiddy973.AllTheCompressed.util.ResourceUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import mekanism.common.registries.MekanismItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.registries.DeferredItem;

public class CraftingRecipes
extends RecipeProvider {
    public CraftingRecipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.craftingRecipes(consumer);
        this.energizingRecipes(consumer);
        for (Overlays value : Overlays.values()) {
            ResourceLocation parent = value.overlay.parent;
            Optional block = BuiltInRegistries.BLOCK.getOptional(parent);
            RecipeOutput conditional = consumer;
            if (!parent.getNamespace().equals("minecraft")) {
                conditional = consumer.withConditions(new ICondition[]{new ModLoadedCondition(parent.getNamespace())});
            }
            if (block.isEmpty() || block.get() == Blocks.AIR) {
                AllTheCompressed.LOGGER.error("missing block during datagen: {}", (Object)parent);
                continue;
            }
            Item ingredient = ((Block)block.get()).asItem();
            for (DeferredItem<BlockItem> item : value.overlay.iall) {
                CraftingRecipes.blockRecipes(item, ingredient, conditional);
                ingredient = (Item)item.get();
            }
        }
    }

    private static void blockRecipes(DeferredItem<BlockItem> item, Item ingredient, RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ingredient, (int)9).requires((ItemLike)item.get()).unlockedBy(CraftingRecipes.getHasName((ItemLike)((ItemLike)item.get())), CraftingRecipes.has((ItemLike)((ItemLike)item.get()))).save(consumer, ResourceUtil.decompress(item.getId()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), (ItemLike)ingredient).pattern("###").pattern("###").pattern("###").unlockedBy(CraftingRecipes.getHasName((ItemLike)ingredient), CraftingRecipes.has((ItemLike)ingredient)).save(consumer, ResourceUtil.compress(item.getId()));
    }

    protected void craftingRecipes(RecipeOutput consumer) {
        CraftingRecipes.blockRecipes(ModRegistry.FLINT_BLOCK_ITEM, Items.FLINT, consumer);
        CraftingRecipes.blockRecipes(ModRegistry.BLAZE_ROD_BLOCK_ITEM, Items.BLAZE_ROD, consumer);
        RecipeOutput mekanism = consumer.withConditions(new ICondition[]{new ModLoadedCondition("mekanism")});
        CraftingRecipes.blockRecipes(ModRegistry.ANTIMATTER_BLOCK_ITEM, (Item)MekanismItems.ANTIMATTER_PELLET.get(), mekanism);
    }

    protected void energizingRecipes(RecipeOutput consumer) {
        RecipeOutput powah = consumer.withConditions(new ICondition[]{new ModLoadedCondition("powah")});
        EnergizingRecipeBuilder.build(Overlays.ENERGIZED_STEEL, 2).setEnergy(90000L).addIngredient(Overlays.IRON).addIngredient(Overlays.GOLD).save(powah);
        EnergizingRecipeBuilder.build(Overlays.BLAZING_CRYSTAL).setEnergy(1080000L).addIngredient(Overlays.BLAZE).save(powah);
        EnergizingRecipeBuilder.build(Overlays.NIOTIC_CRYSTAL).setEnergy(2700000L).addIngredient(Overlays.DIAMOND).save(powah);
        EnergizingRecipeBuilder.build(Overlays.SPIRITED_CRYSTAL).setEnergy(9000000L).addIngredient(Overlays.EMERALD).save(powah);
    }
}

