/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.client.FARenderTypes;
import com.stal111.forbidden_arcanus.common.block.entity.BlackHoleBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;

public class BlackHoleRenderer
implements BlockEntityRenderer<BlackHoleBlockEntity> {
    public static final ModelLayerLocation BLACK_HOLE_LAYER = new ModelLayerLocation(ForbiddenArcanus.location("black_hole"), "main");
    public static final ModelLayerLocation BLACK_HOLE_AURA_LAYER = new ModelLayerLocation(ForbiddenArcanus.location("black_hole"), "aura");
    private static final ResourceLocation BLACK_HOLE_TEXTURE = ForbiddenArcanus.location("textures/block/black_hole.png");
    private static final ResourceLocation[] BLACK_HOLE_AURA = new ResourceLocation[]{ForbiddenArcanus.location("textures/block/black_hole_aura_0.png"), ForbiddenArcanus.location("textures/block/black_hole_aura_1.png"), ForbiddenArcanus.location("textures/block/black_hole_aura_2.png")};
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)BLACK_HOLE_TEXTURE);
    private static final RenderType[] AURA_RENDER_TYPE = new RenderType[]{FARenderTypes.entityFullbrightCutout(BLACK_HOLE_AURA[0]), FARenderTypes.entityFullbrightCutout(BLACK_HOLE_AURA[1]), FARenderTypes.entityFullbrightCutout(BLACK_HOLE_AURA[2])};
    private static final float SIN_45 = (float)Math.sin(1.0471975511965976);
    private final ModelPart hole;
    private final ModelPart aura;

    public BlackHoleRenderer(BlockEntityRendererProvider.Context context) {
        this.hole = context.bakeLayer(BLACK_HOLE_LAYER);
        this.aura = context.bakeLayer(BLACK_HOLE_AURA_LAYER);
    }

    public static LayerDefinition createHoleLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        meshDefinition.getRoot().addOrReplaceChild("hole", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)16, (int)16);
    }

    public static LayerDefinition createAuraLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        meshDefinition.getRoot().addOrReplaceChild("aura", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, 0.0f, -10.0f, 20.0f, 0.1f, 20.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)20, (int)20);
    }

    public void render(@Nonnull BlackHoleBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RENDER_TYPE);
        float rotation = ((float)blockEntity.rotation + partialTicks) * 3.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.pushPose();
        poseStack.mulPose(new Quaternionf().setAngleAxis(1.0471975511965976, (double)SIN_45, 0.0, (double)SIN_45));
        this.hole.render(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.popPose();
        vertexconsumer = bufferSource.getBuffer(AURA_RENDER_TYPE[blockEntity.auraTexture]);
        this.aura.render(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

