/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.dispenser;

import com.stal111.forbidden_arcanus.common.block.MagicalFarmlandBlock;
import com.stal111.forbidden_arcanus.common.item.ArcaneBoneMealItem;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ArcaneBoneMealDispenseBehavior
extends OptionalDispenseItemBehavior {
    @Nonnull
    protected ItemStack execute(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
        ServerLevel level = source.level();
        BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        BlockState state = level.getBlockState(pos);
        this.setSuccess(true);
        if (state.is(Blocks.FARMLAND)) {
            stack.shrink(1);
            level.setBlockAndUpdate(pos, (BlockState)((MagicalFarmlandBlock)((Object)ModBlocks.MAGICAL_FARMLAND.get())).defaultBlockState().setValue((Property)BlockStateProperties.MOISTURE, (Comparable)((Integer)state.getValue((Property)BlockStateProperties.MOISTURE))));
            level.levelEvent(null, 2001, pos, Block.getId((BlockState)state));
        } else if (ArcaneBoneMealItem.applyBoneMeal(stack, (Level)level, pos, null)) {
            if (!level.isClientSide()) {
                level.levelEvent(2005, pos, 0);
            }
        } else {
            this.setSuccess(false);
        }
        return stack;
    }
}

