/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity;

import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.util.ModTags;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlackHoleBlockEntity
extends BlockEntity {
    private static final double DAMAGE_DISTANCE = 0.6;
    private static final int PLAYER_SEARCH_DISTANCE = 6;
    private final List<ItemEntity> thrownOutItems = new ArrayList<ItemEntity>();
    private double stored_xp;
    public int rotation = 0;
    public int tickCounter;
    public int auraTexture = 0;

    public BlackHoleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BLACK_HOLE.get(), pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlackHoleBlockEntity blockEntity) {
        ++blockEntity.rotation;
        ++blockEntity.tickCounter;
        if (blockEntity.tickCounter == 5 || blockEntity.tickCounter == 10) {
            ++blockEntity.auraTexture;
        } else if (blockEntity.tickCounter == 15) {
            blockEntity.tickCounter = 0;
            blockEntity.auraTexture = 0;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlackHoleBlockEntity blockEntity) {
        List entities = level.getEntities(null, new AABB((double)pos.getX() + 0.5 - 5.0, (double)pos.getY() + 0.5 - 5.0, (double)pos.getZ() + 0.5 - 5.0, (double)pos.getX() + 0.5 + 5.0, (double)pos.getY() + 0.5 + 5.0, (double)pos.getZ() + 0.5 + 5.0));
        for (Entity entity : entities) {
            ItemEntity itemEntity2;
            if (!entity.getType().is(ModTags.EntityTypes.BLACK_HOLE_AFFECTED) || entity instanceof ItemEntity && !blockEntity.isAffectedItem(itemEntity2 = (ItemEntity)entity)) continue;
            double distance = entity.position().distanceTo(pos.getCenter());
            double movementFactor = blockEntity.getMovementFactor(distance);
            entity.push(((double)pos.getX() + 0.5 - entity.getX()) * movementFactor, ((double)pos.getY() + 0.5 - entity.getY() + 1.25) * movementFactor, ((double)pos.getZ() + 0.5 - entity.getZ()) * movementFactor);
            if (!(distance <= 0.6)) continue;
            if (entity instanceof ExperienceOrb) {
                ExperienceOrb experienceOrb = (ExperienceOrb)entity;
                blockEntity.stored_xp += (double)experienceOrb.getValue();
                if (blockEntity.stored_xp >= 60.0) {
                    blockEntity.throwOutItemStack(level, new ItemStack((ItemLike)ModItems.XPETRIFIED_ORB.get()), pos.getCenter());
                    blockEntity.stored_xp = 0.0;
                }
                experienceOrb.kill();
                continue;
            }
            entity.hurt(level.damageSources().magic(), 4.0f);
        }
        blockEntity.thrownOutItems.removeIf(itemEntity -> !itemEntity.isAlive());
    }

    public boolean isAffectedItem(ItemEntity entity) {
        return !this.thrownOutItems.contains(entity) && !entity.getItem().is(ModTags.Items.BLACK_HOLE_UNAFFECTED);
    }

    private void throwOutItemStack(Level level, ItemStack stack, Vec3 pos) {
        ItemEntity item = new ItemEntity(level, pos.x(), pos.y(), pos.z(), stack);
        Player nearestPlayer = level.getNearestPlayer(pos.x(), pos.y(), pos.z(), 6.0, false);
        if (nearestPlayer == null) {
            this.setRandomVelocity(item, level.getRandom());
        } else {
            item.push((nearestPlayer.getX() - item.getX()) * 0.09, (nearestPlayer.getY() - item.getY() + 1.25) * 0.09, (nearestPlayer.getZ() - item.getZ()) * 0.09);
        }
        this.thrownOutItems.add(item);
        level.addFreshEntity((Entity)item);
    }

    private double getMovementFactor(double distance) {
        return distance <= 3.0 ? 0.035 : 0.02;
    }

    private void setRandomVelocity(ItemEntity itemEntity, RandomSource random) {
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        itemEntity.setDeltaMovement(random.nextBoolean() ? x : -x, random.nextBoolean() ? y : -y, random.nextBoolean() ? z : -z);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.stored_xp = tag.getDouble("StoredXP");
    }

    public void saveAdditional(@Nonnull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putDouble("StoredXP", this.stored_xp);
    }
}

