/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.crafting;

import com.google.errorprone.annotations.DoNotCall;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoCookingTimes;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueChance;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipeInput;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModRecipeSerializers;
import com.stal111.forbidden_arcanus.core.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;

public record ClibanoRecipe(String group, CookingBookCategory category, Either<Ingredient, Pair<Ingredient, Ingredient>> ingredients, ItemStack result, float experience, ClibanoCookingTimes cookingTimes, Optional<ResidueChance> residueChance, ClibanoFireType requiredFireType, Optional<Holder<EnhancerDefinition>> requiredEnhancer) implements Recipe<ClibanoRecipeInput>
{
    public static final ClibanoCookingTimes DEFAULT_COOKING_TIMES = ClibanoCookingTimes.of(100);

    public boolean matches(@NotNull ClibanoRecipeInput recipeInput, @NotNull Level level, HolderSet<EnhancerDefinition> enhancers) {
        if (!this.enhancerMatches(enhancers)) {
            return false;
        }
        return this.matches(recipeInput, level);
    }

    private boolean enhancerMatches(HolderSet<EnhancerDefinition> enhancers) {
        return this.requiredEnhancer.isEmpty() || enhancers.contains(this.requiredEnhancer.get());
    }

    @DoNotCall
    public boolean matches(@NotNull ClibanoRecipeInput recipeInput, @NotNull Level level) {
        List list;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(recipeInput.getInputs());
        return RecipeMatcher.findMatches(inputs, (List)(list = (List)this.ingredients.map(List::of, pair -> List.of((Ingredient)pair.getFirst(), (Ingredient)pair.getSecond())))) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull ClibanoRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return (NonNullList)this.ingredients.map(ingredient -> NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredient}), pair -> NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{(Ingredient)pair.getFirst(), (Ingredient)pair.getSecond()}));
    }

    public int getDefaultCookingTime() {
        return this.cookingTimes.get(this.requiredFireType);
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean isDoubleRecipe() {
        return this.ingredients.right().isPresent();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CLIBANO_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.CLIBANO_COMBUSTION.get();
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.CLIBANO_CORE.get());
    }

    public static class Serializer
    implements RecipeSerializer<ClibanoRecipe> {
        private static final MapCodec<ClibanoRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ClibanoRecipe::group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(ClibanoRecipe::category), (App)Codec.either((Codec)Ingredient.CODEC_NONEMPTY, (Codec)Codec.mapPair((MapCodec)Ingredient.MAP_CODEC_NONEMPTY.fieldOf("first"), (MapCodec)Ingredient.MAP_CODEC_NONEMPTY.fieldOf("second")).codec()).fieldOf("ingredients").forGetter(ClibanoRecipe::ingredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(ClibanoRecipe::result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(ClibanoRecipe::experience), (App)ClibanoCookingTimes.CODEC.fieldOf("cooking_time").orElse((Object)DEFAULT_COOKING_TIMES).forGetter(ClibanoRecipe::cookingTimes), (App)ResidueChance.CODEC.optionalFieldOf("residue").forGetter(ClibanoRecipe::residueChance), (App)ClibanoFireType.CODEC.fieldOf("fire_type").orElse((Object)ClibanoFireType.FIRE).forGetter(ClibanoRecipe::requiredFireType), (App)EnhancerDefinition.REFERENCE_CODEC.optionalFieldOf("enhancer").forGetter(ClibanoRecipe::requiredEnhancer)).apply((Applicative)instance, ClibanoRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ClibanoRecipe> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)CODEC.codec());

        @NotNull
        public MapCodec<ClibanoRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ClibanoRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

