/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.core.mixin;

import com.stal111.forbidden_arcanus.common.item.modifier.ItemModifier;
import com.stal111.forbidden_arcanus.common.item.modifier.ModifierHelper;
import com.stal111.forbidden_arcanus.data.ModItemModifiers;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    @NotNull
    public abstract ItemStack getItemBySlot(@NotNull EquipmentSlot var1);

    @Shadow
    protected abstract void touch(Entity var1);

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;playShoulderEntityAmbientSound(Lnet/minecraft/nbt/CompoundTag;)V")}, method={"aiStep"})
    public void forbiddenArcanus_aiStep(CallbackInfo ci) {
        if (this.getHealth() > 0.0f && !this.isSpectator() && ModifierHelper.hasModifier(this.getItemBySlot(EquipmentSlot.FEET), (Holder<ItemModifier>)this.level().holderOrThrow(ModItemModifiers.MAGNETIZED))) {
            if (this.isPassenger() && !this.getVehicle().isRemoved()) {
                return;
            }
            AABB aabb = this.getBoundingBox().inflate(2.5, 1.5, 2.5);
            List list = this.level().getEntities((Entity)this, aabb);
            for (Entity entity : list) {
                if (!(entity instanceof ItemEntity)) continue;
                this.touch(entity);
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onGround()Z"), method={"getDigSpeed"})
    public boolean forbiddenArcanus_getDigSpeed$seaPrismModifier(Player instance) {
        boolean onGround = instance.onGround();
        if (!onGround && this.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) && ModifierHelper.hasModifier(instance.getItemBySlot(EquipmentSlot.HEAD), (Holder<ItemModifier>)this.level().holderOrThrow(ModItemModifiers.AQUATIC))) {
            return true;
        }
        return onGround;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;tick()V")}, method={"aiStep"})
    public void forbiddenArcanus_aiStep$seaPrismModifier(CallbackInfo ci) {
        if (this.getHealth() < this.getMaxHealth() && this.tickCount % 100 == 0 && this.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) && ModifierHelper.hasModifier(this.getItemBySlot(EquipmentSlot.HEAD), (Holder<ItemModifier>)this.level().holderOrThrow(ModItemModifiers.AQUATIC))) {
            this.heal(2.0f);
        }
    }
}

