/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModTags;
import mob_grinding_utils.blocks.BlockDirtSpawner;
import mob_grinding_utils.events.DirtSpawnEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;

public class BlockDreadfulDirt
extends BlockDirtSpawner {
    public BlockDreadfulDirt(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean shouldCatchFire(LevelAccessor level, BlockPos pos) {
        return level.canSeeSkyFromBelowWater(pos) && (level.dayTime() < 13000L || level.dayTime() > 23000L);
    }

    public boolean shouldSpawnMob(LevelAccessor level, BlockPos pos) {
        return level.getMaxLocalRawBrightness(pos.above()) < 5;
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        if (this.shouldCatchFire((LevelAccessor)level, pos) || this.shouldSpawnMob((LevelAccessor)level, pos)) {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.getRandom(), (int)20, (int)60));
        }
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (this.shouldCatchFire(level, pos) || this.shouldSpawnMob(level, pos)) {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.getRandom(), (int)20, (int)60));
        }
        return super.updateShape(stateIn, facing, facingState, level, pos, facingPos);
    }

    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (this.shouldCatchFire((LevelAccessor)level, pos) || this.shouldSpawnMob((LevelAccessor)level, pos)) {
            level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.getRandom(), (int)20, (int)60));
        }
    }

    public void randomTick(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        AABB areaToCheck;
        int entityCount;
        if (this.shouldCatchFire((LevelAccessor)level, pos)) {
            BlockPos posUp = pos.above();
            BlockState blockstate = BaseFireBlock.getState((BlockGetter)level, (BlockPos)posUp);
            if (level.getBlockState(posUp).isAir() && blockstate.canSurvive((LevelReader)level, posUp)) {
                level.setBlock(posUp, blockstate, 11);
            }
        }
        if (!this.shouldCatchFire((LevelAccessor)level, pos) && this.shouldSpawnMob((LevelAccessor)level, pos) && (entityCount = level.getEntitiesOfClass(Mob.class, areaToCheck = new AABB(pos).inflate(5.0, 2.0, 5.0), entity -> entity instanceof Enemy).size()) < 8) {
            this.spawnMob(level, pos);
        }
    }

    public void spawnMob(ServerLevel level, BlockPos pos) {
        Holder biomeHolder = level.getBiome(pos);
        Biome biome = !biomeHolder.is(ModTags.Biomes.HOSTILE_OVERRIDE) ? (Biome)biomeHolder.value() : level.registryAccess().registry(Registries.BIOME).flatMap(reg -> reg.getOptional(Biomes.PLAINS)).orElseGet(() -> ((Holder)biomeHolder).value());
        List spawns = biome.getMobSettings().getMobs(MobCategory.MONSTER).unwrap();
        if (!spawns.isEmpty()) {
            int indexSize = spawns.size();
            EntityType type = ((MobSpawnSettings.SpawnerData)spawns.get((int)level.getRandom().nextInt((int)indexSize))).type;
            if (type.is(ModTags.Entities.NO_DIRT_SPAWN) || type.is(ModTags.Entities.NO_DREADFUL_SPAWN)) {
                return;
            }
            Mob entity = (Mob)type.create((Level)level);
            if (entity == null) {
                return;
            }
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            if (!BlockDreadfulDirt.checkSpawnPosition(entity, (ServerLevelAccessor)level, MobSpawnType.NATURAL)) {
                return;
            }
            if (level.getEntities((EntityTypeTest)entity.getType(), entity.getBoundingBox(), EntitySelector.ENTITY_STILL_ALIVE).isEmpty() && level.noCollision((Entity)entity)) {
                TriState result = DirtSpawnEvent.checkEvent(entity, (LevelAccessor)level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, DirtSpawnEvent.DirtType.DELIGHTFUL);
                if (result == TriState.FALSE) {
                    return;
                }
                EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(pos), (MobSpawnType)MobSpawnType.NATURAL, null);
                level.addFreshEntity((Entity)entity);
            }
        }
    }

    public boolean isFlammable(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull Direction face) {
        return true;
    }

    public int getFlammability(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull Direction face) {
        return 200;
    }

    public boolean isFireSource(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return side == Direction.UP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@Nonnull BlockState stateIn, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.getX() + rand.nextFloat();
            double d1 = (float)pos.getY() + rand.nextFloat();
            double d2 = (float)pos.getZ() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }
}

