/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import mob_grinding_utils.network.MGUClientPackets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ChickenSyncPacket(int chickenID, CompoundTag nbt) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChickenSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mob_grinding_utils", (String)"chicken_sync"));
    public static final StreamCodec<FriendlyByteBuf, ChickenSyncPacket> STREAM_CODEC = CustomPacketPayload.codec(ChickenSyncPacket::write, ChickenSyncPacket::new);

    public ChickenSyncPacket(LivingEntity chicken, CompoundTag chickenNBT) {
        this(chicken.getId(), chickenNBT);
    }

    public ChickenSyncPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readNbt());
    }

    public static void handle(ChickenSyncPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> MGUClientPackets.HandleChickenSync(message));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.chickenID);
        buf.writeNbt((Tag)this.nbt);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

