/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.internal.AbstractNamedValue;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Reactant
extends AbstractNamedValue
implements Predicate<ReactantType> {
    public static final ModCodecs<Reactant, ByteBuf> CODECS = new ModCodecs(RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(AbstractNamedValue::getName), (App)ReactantType.CODECS.field("type", Reactant::getType), (App)Colour.CODECS.field("colour", Reactant::getColour), (App)Codec.STRING.fieldOf("translation").forGetter(AbstractNamedValue::getTranslationKey), (App)FuelProperties.CODECS.field("fuelprop", Reactant::getFuelData)).apply((Applicative)instance, Reactant::new)), StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AbstractNamedValue::getName, (StreamCodec)ReactantType.CODECS.streamCodec(), Reactant::getType, (StreamCodec)Colour.CODECS.streamCodec(), Reactant::getColour, (StreamCodec)ByteBufCodecs.STRING_UTF8, AbstractNamedValue::getTranslationKey, (StreamCodec)FuelProperties.CODECS.streamCodec(), Reactant::getFuelData, Reactant::new));
    private final ReactantType _type;
    private final Colour _colour;
    private final FuelProperties _fuelData;

    Reactant(String name, ReactantType type, int rgbColour, String translationKey, FuelProperties fuelData) {
        this(name, type, Colour.fromRGB((int)rgbColour), translationKey, fuelData);
    }

    public ReactantType getType() {
        return this._type;
    }

    public Colour getColour() {
        return this._colour;
    }

    public FuelProperties getFuelData() {
        return this._fuelData;
    }

    public int getMinimumSolidSourceAmount() {
        return ReactantMappingsRegistry.getToSolid(this).orElseGet(Collections::emptyList).stream().mapToInt(IMapping::getSourceAmount).reduce(Integer::min).orElse(-1);
    }

    public int getMinimumFluidSourceAmount() {
        return ReactantMappingsRegistry.getToFluid(this).map($ -> 1).orElse(-1);
    }

    public Reactant copy() {
        return new Reactant(this.getName(), this.getType(), this.getColour().toRGBA(), this.getTranslationKey(), this.getFuelData());
    }

    @Override
    public boolean test(ReactantType type) {
        return this.getType() == type;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Reactant) || !super.equals(other)) {
            return false;
        }
        Reactant reactant = (Reactant)other;
        return this._type == reactant._type && Objects.equals(this._colour, reactant._colour) && Objects.equals(this._fuelData, reactant._fuelData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this._type, this._colour, this._fuelData});
    }

    private Reactant(String name, ReactantType type, Colour colour, String translationKey, FuelProperties fuelData) {
        super(name, translationKey);
        this._type = Objects.requireNonNull(type);
        this._colour = Objects.requireNonNull(colour);
        this._fuelData = type.isFuel() ? Objects.requireNonNull(fuelData) : FuelProperties.INVALID;
    }
}

