/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.config;

import it.zerono.mods.extremereactors.config.Client;
import it.zerono.mods.extremereactors.config.Common;
import it.zerono.mods.zerocore.lib.CodeHelper;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    public static final Client CLIENT;
    public static final Common COMMON;
    private static final ModConfigSpec s_clientSpec;
    private static final ModConfigSpec s_commonSpec;

    public static void initialize(ModContainer container) {
        Config.register(container, ModConfig.Type.CLIENT, s_clientSpec);
        Config.register(container, ModConfig.Type.COMMON, s_commonSpec);
    }

    private static void register(ModContainer container, ModConfig.Type type, ModConfigSpec spec) {
        container.registerConfig(type, (IConfigSpec)spec, String.format("extremereactors/%s.toml", type.extension()));
    }

    static {
        if (!CodeHelper.ioCreateModConfigDirectory((String)"extremereactors")) {
            throw new RuntimeException("Unable to create a directory for the Extreme Reactors config files");
        }
        Pair pair1 = new ModConfigSpec.Builder().configure(Client::new);
        Pair pair2 = new ModConfigSpec.Builder().configure(Common::new);
        CLIENT = (Client)pair1.getLeft();
        s_clientSpec = (ModConfigSpec)pair1.getRight();
        COMMON = (Common)pair2.getLeft();
        s_commonSpec = (ModConfigSpec)pair2.getRight();
    }
}

