/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.TransitionsRegistry;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.ExtremeReactorsJeiPlugin;
import it.zerono.mods.zerocore.lib.compat.jei.AbstractModRecipeCategory;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TransitionsRecipeCategory<Input, Output, Recipe extends AbstractTransition<Input, Output>>
extends AbstractModRecipeCategory<Recipe> {
    private final List<Recipe> _transitions;

    public static TransitionsRecipeCategory<Coolant, Vapor, VaporizationTransition> vaporization(IGuiHelper guiHelper) {
        return new TransitionsRecipeCategory<Coolant, Vapor, VaporizationTransition>(RecipeType.create((String)"bigreactors", (String)"jei_vaporizations", VaporizationTransition.class), "compat.bigreactors.jei.vaporization.recipecategory.title", new ItemStack((ItemLike)Content.Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED.get()), guiHelper, TransitionsRegistry.getVaporizations().values().stream().map(VaporizationTransition::new).collect(Collectors.toList()));
    }

    public static TransitionsRecipeCategory<Vapor, Coolant, CondensationTransition> condensation(IGuiHelper guiHelper) {
        return new TransitionsRecipeCategory<Vapor, Coolant, CondensationTransition>(RecipeType.create((String)"bigreactors", (String)"jei_condensations", CondensationTransition.class), "compat.bigreactors.jei.condensation.recipecategory.title", new ItemStack((ItemLike)Content.Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED.get()), guiHelper, TransitionsRegistry.getCondensations().values().stream().map(CondensationTransition::new).collect(Collectors.toList()));
    }

    public List<Recipe> getTransitions() {
        return this._transitions;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        ((AbstractTransition)recipe).setRecipe(builder, focuses);
    }

    protected TransitionsRecipeCategory(RecipeType<Recipe> type, String titleTranslationKey, ItemStack icon, IGuiHelper guiHelper, List<Recipe> transitions) {
        super(type, (Component)Component.translatable((String)titleTranslationKey), icon, guiHelper, (IDrawable)ExtremeReactorsJeiPlugin.defaultMappingDrawable(guiHelper));
        this._transitions = Objects.requireNonNull(transitions);
    }

    public static class VaporizationTransition
    extends AbstractTransition<Coolant, Vapor> {
        public VaporizationTransition(IMapping<Coolant, Vapor> mapping) {
            super(mapping);
        }

        @Override
        protected void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focuses) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 20).addIngredients(ExtremeReactorsJeiPlugin.COOLANT_INGREDIENT_TYPE, (List)ObjectLists.singleton((Object)((Coolant)this.getInput())));
            builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 20).addIngredients(ExtremeReactorsJeiPlugin.VAPOR_INGREDIENT_TYPE, (List)ObjectLists.singleton((Object)((Vapor)this.getOutput())));
        }
    }

    public static class CondensationTransition
    extends AbstractTransition<Vapor, Coolant> {
        public CondensationTransition(IMapping<Vapor, Coolant> mapping) {
            super(mapping);
        }

        @Override
        protected void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focuses) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 20).addIngredients(ExtremeReactorsJeiPlugin.VAPOR_INGREDIENT_TYPE, (List)ObjectLists.singleton((Object)((Vapor)this.getInput())));
            builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 20).addIngredients(ExtremeReactorsJeiPlugin.COOLANT_INGREDIENT_TYPE, (List)ObjectLists.singleton((Object)((Coolant)this.getOutput())));
        }
    }

    public static abstract class AbstractTransition<Input, Output> {
        private final IMapping<Input, Output> _mapping;

        protected AbstractTransition(IMapping<Input, Output> mapping) {
            this._mapping = Objects.requireNonNull(mapping);
        }

        public Input getInput() {
            return this._mapping.getSource();
        }

        public Output getOutput() {
            return this._mapping.getProduct();
        }

        protected abstract void setRecipe(IRecipeLayoutBuilder var1, IFocusGroup var2);
    }
}

