/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor;

import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.InputSensorAction;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;

public abstract class AbstractSensorSetting<Reader extends IMachineReader, Writer, SensorType extends ISensorType<Reader>>
implements Predicate<Reader>,
InputSensorAction<Writer> {
    public final SensorType Sensor;
    public final SensorBehavior Behavior;
    public final int Value1;
    public final int Value2;

    protected AbstractSensorSetting(SensorType sensor, SensorBehavior behavior, int v1, int v2) {
        this.Sensor = sensor;
        this.Behavior = behavior;
        this.Value1 = v1;
        this.Value2 = v2;
    }

    protected AbstractSensorSetting(CompoundTag data, Function<CompoundTag, SensorType> sensorTypeGetter) throws IllegalArgumentException {
        if (!(data.contains("behavior") && data.contains("v1") && data.contains("v2"))) {
            throw new IllegalArgumentException("Invalid NBT data");
        }
        this.Sensor = (ISensorType)sensorTypeGetter.apply(data);
        this.Behavior = (SensorBehavior)NBTHelper.nbtGetEnum((CompoundTag)data, (String)"behavior", SensorBehavior::valueOf, (Enum)SensorBehavior.Disabled);
        this.Value1 = data.getInt("v1");
        this.Value2 = data.getInt("v2");
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        NBTHelper.nbtSetEnum((CompoundTag)data, (String)"behavior", (Enum)this.Behavior);
        data.putInt("v1", this.Value1);
        data.putInt("v2", this.Value2);
        return data;
    }

    @Override
    public boolean test(Reader reader) {
        return this.Sensor.isOutput() && this.Behavior.outputTest(this.Sensor.applyAsInt(reader), this.Value1, this.Value2);
    }
}

