/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.computer;

import com.google.common.collect.Maps;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractEnergyGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.MultiBlockEnergizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.EnergizerComputerPortEntity;
import it.zerono.mods.zerocore.lib.IActivableMachine;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.IComputerMethodHandler;
import it.zerono.mods.zerocore.lib.compat.computer.LuaHelper;
import it.zerono.mods.zerocore.lib.compat.computer.MultiblockComputerPeripheral;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class EnergizerComputerPeripheral
extends MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity> {
    public EnergizerComputerPeripheral(EnergizerComputerPortEntity port) {
        super((AbstractMultiblockPart)port);
    }

    public String getPeripheralStaticName() {
        return "extremereactor-energizerComputerPort";
    }

    public void populateMethods(Consumer<@NotNull ComputerMethod<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>>> methodConsumer) {
        super.populateMethods(methodConsumer);
        methodConsumer.accept((ComputerMethod<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>>)new ComputerMethod("getActive", this.wrapControllerValue(IActivableMachine::isMachineActive)));
        methodConsumer.accept((ComputerMethod<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>>)new ComputerMethod("setActive", this.wrapControllerAction((c, arguments) -> c.setMachineActive(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0))), 1, true));
        this.addEnergyMethod(methodConsumer, "getEnergyStored", AbstractEnergyGeneratorMultiblockController::getEnergyStored);
        this.addEnergyMethod(methodConsumer, "getEnergyCapacity", AbstractEnergyGeneratorMultiblockController::getCapacity);
        this.addEnergyMethod(methodConsumer, "getEnergyIoLastTick", MultiBlockEnergizer::getEnergyIoRate);
        this.addEnergyMethod(methodConsumer, "getEnergyInsertedLastTick", MultiBlockEnergizer::getEnergyInsertedLastTick);
        this.addEnergyMethod(methodConsumer, "getEnergyExtractedLastTick", MultiBlockEnergizer::getEnergyExtractedLastTick);
        methodConsumer.accept((ComputerMethod<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>>)new ComputerMethod("getEnergyStats", this.wrapControllerValue(c -> {
            HashMap stats = Maps.newHashMap();
            EnergySystem sys = c.getOutputEnergySystem();
            stats.put("energyStored", c.getEnergyStored(sys).doubleValue());
            stats.put("energyCapacity", c.getCapacity(sys).doubleValue());
            stats.put("energyIoLastTick", c.getEnergyIoRate(sys).doubleValue());
            stats.put("energyInsertedLastTick", c.getEnergyInsertedLastTick(sys).doubleValue());
            stats.put("energyExtractedLastTick", c.getEnergyExtractedLastTick(sys).doubleValue());
            stats.put("energySystem", sys.getUnit());
            return stats;
        })));
        methodConsumer.accept((ComputerMethod<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>>)new ComputerMethod("getEnergyStatsAsText", this.wrapControllerValue(c -> {
            HashMap stats = Maps.newHashMap();
            EnergySystem sys = c.getOutputEnergySystem();
            stats.put("energyStored", sys.asHumanReadableNumber(c.getEnergyStored(sys)));
            stats.put("energyCapacity", sys.asHumanReadableNumber(c.getCapacity(sys)));
            stats.put("energyIoLastTick", sys.asHumanReadableNumber(c.getEnergyIoRate(sys)));
            stats.put("energyInsertedLastTick", sys.asHumanReadableNumber(c.getEnergyInsertedLastTick(sys)));
            stats.put("energyExtractedLastTick", sys.asHumanReadableNumber(c.getEnergyExtractedLastTick(sys)));
            stats.put("energySystem", sys.getUnit());
            return stats;
        })));
    }

    private void addEnergyMethod(Consumer<@NotNull ComputerMethod<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>>> methodConsumer, String methodBaseName, BiFunction<@NotNull MultiBlockEnergizer, @NotNull EnergySystem, @NotNull WideAmount> getter) {
        methodConsumer.accept((ComputerMethod<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>>)new ComputerMethod(methodBaseName, this.energy(getter)));
        methodConsumer.accept((ComputerMethod<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>>)new ComputerMethod(methodBaseName + "AsText", this.energyAsText(getter)));
    }

    private IComputerMethodHandler<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>> energy(BiFunction<@NotNull MultiBlockEnergizer, @NotNull EnergySystem, @NotNull WideAmount> getter) {
        return this.wrapControllerValue(c -> ((WideAmount)getter.apply((MultiBlockEnergizer)((Object)c), c.getOutputEnergySystem())).doubleValue());
    }

    private IComputerMethodHandler<MultiblockComputerPeripheral<MultiBlockEnergizer, EnergizerComputerPortEntity>> energyAsText(BiFunction<@NotNull MultiBlockEnergizer, @NotNull EnergySystem, @NotNull WideAmount> getter) {
        return this.wrapControllerValue(c -> {
            EnergySystem sys = c.getOutputEnergySystem();
            return sys.asHumanReadableNumber((WideAmount)getter.apply((MultiBlockEnergizer)((Object)c), sys));
        });
    }
}

