/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.recipe.AbstractTwoToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.AbstractHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidizerSolidMixingRecipe
extends AbstractTwoToOneRecipe<ItemStack, ItemStack, FluidStack, ItemStackRecipeIngredient, ItemStackRecipeIngredient, FluidStackRecipeResult>
implements IFluidizerRecipe {
    private static long s_maxResultAmount = 0L;

    public FluidizerSolidMixingRecipe(ItemStackRecipeIngredient ingredient1, ItemStackRecipeIngredient ingredient2, FluidStackRecipeResult result) {
        super((IRecipeIngredient)ingredient1, (IRecipeIngredient)ingredient2, (IRecipeResult)result);
        s_maxResultAmount = Math.max(s_maxResultAmount, result.getAmount());
    }

    public static boolean lookup(ModRecipe recipe, IRecipeIngredientSource<ItemStack> source1, IRecipeIngredientSource<ItemStack> source2) {
        return recipe instanceof FluidizerSolidMixingRecipe && ((FluidizerSolidMixingRecipe)recipe).test((ItemStack)source1.getIngredient(), (ItemStack)source2.getIngredient());
    }

    public static long getMaxResultAmount() {
        return s_maxResultAmount;
    }

    @Override
    public IFluidizerRecipe.Type getRecipeType() {
        return IFluidizerRecipe.Type.SolidMixing;
    }

    public boolean match(ItemStack stack) {
        return ((ItemStackRecipeIngredient)this.getIngredient1()).test(stack) || ((ItemStackRecipeIngredient)this.getIngredient2()).test(stack);
    }

    public boolean match(ItemStack stack1, ItemStack stack2) {
        ItemStackRecipeIngredient ingredient1 = (ItemStackRecipeIngredient)this.getIngredient1();
        ItemStackRecipeIngredient ingredient2 = (ItemStackRecipeIngredient)this.getIngredient2();
        return ingredient1.test(stack1) && ingredient2.test(stack2);
    }

    public boolean matchIgnoreAmount(ItemStack stack) {
        return ((ItemStackRecipeIngredient)this.getIngredient1()).testIgnoreAmount(stack) || ((ItemStackRecipeIngredient)this.getIngredient2()).testIgnoreAmount(stack);
    }

    public static RecipeSerializer<FluidizerSolidMixingRecipe> createSerializer() {
        return AbstractTwoToOneRecipe.createSerializer((String)"ingredient1", (ModCodecs)ItemStackRecipeIngredient.CODECS, (String)"ingredient2", (ModCodecs)ItemStackRecipeIngredient.CODECS, (String)"result", (ModCodecs)FluidStackRecipeResult.CODECS, FluidizerSolidMixingRecipe::new);
    }

    @Override
    public int getEnergyUsageMultiplier() {
        return this.getEnergyUsageMultiplier(((FluidStackRecipeResult)this.getResult()).getResult());
    }

    public RecipeSerializer<FluidizerSolidMixingRecipe> getSerializer() {
        return Content.Recipes.FLUIDIZER_SOLIDMIXING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)Content.Recipes.FLUIDIZER_RECIPE_TYPE.get();
    }

    public static class HeldRecipe
    extends AbstractHeldRecipe<FluidizerSolidMixingRecipe>
    implements IFluidizerRecipe.Held<FluidizerSolidMixingRecipe> {
        private final IRecipeIngredientSource<ItemStack> _item1Source;
        private final IRecipeIngredientSource<ItemStack> _item2Source;
        private final IRecipeResultTarget<FluidStackRecipeResult> _outputTarget;

        public <Holder extends IRecipeHolder<FluidizerSolidMixingRecipe>> HeldRecipe(FluidizerSolidMixingRecipe recipe, Holder holder, IRecipeIngredientSource<ItemStack> item1Source, IRecipeIngredientSource<ItemStack> item2Source, IRecipeResultTarget<FluidStackRecipeResult> outputTarget) {
            super((ModRecipe)recipe, holder);
            this._item1Source = item1Source;
            this._item2Source = item2Source;
            this._outputTarget = outputTarget;
        }

        public void onRecipeProcessed() {
            FluidizerSolidMixingRecipe recipe = (FluidizerSolidMixingRecipe)this.getRecipe();
            ItemStack item1 = (ItemStack)this._item1Source.getMatchFrom(recipe.getIngredient1());
            ItemStack item2 = (ItemStack)this._item2Source.getMatchFrom(recipe.getIngredient2());
            if (!item1.isEmpty() && !item2.isEmpty()) {
                this._item1Source.consumeIngredient((Object)item1);
                this._item2Source.consumeIngredient((Object)item2);
                this._outputTarget.setResult((IRecipeResult)((FluidStackRecipeResult)recipe.getResult()), OperationMode.Execute);
            }
        }
    }
}

