/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.util.config;

import com.cursee.monolib.Constants;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface ISimpleConfig {
    public String identifier();

    public LinkedHashMap<String, Object> values();

    default public Set<String> keys() {
        return this.values().keySet();
    }

    default public boolean hasKey(String s) {
        return this.values().containsKey(s);
    }

    default public void putEntry(String key, Object value, boolean replaceExisting) {
        if (this.values().containsKey(key) && !replaceExisting) {
            throw new IllegalStateException(this.identifier() + ": Attempted to overwrite " + key);
        }
        this.values().put(key, value);
    }

    default public Object get(String key) {
        if (!this.values().containsKey(key)) {
            throw new IllegalStateException(this.identifier() + ": Attempted to get missing key " + key);
        }
        if (this.values().get(key) == null) {
            throw new IllegalStateException(this.identifier() + ": Attempted to get null value " + key);
        }
        return this.values().get(key);
    }

    private <T> T getObjectOfType(String key, Class<T> clazz) {
        Object obj = this.get(key);
        if (!clazz.isInstance(obj)) {
            throw new IllegalStateException(this.identifier() + " expected " + clazz.getSimpleName() + " but got " + obj.getClass().getSimpleName() + " for key: " + key);
        }
        return (T)obj;
    }

    default public <T> T getOrDefault(String key, T defaultValue) {
        if (!this.values().containsKey(key)) {
            Constants.LOG.info("{} did not find key \"{}\", providing default: {}", new Object[]{this.identifier(), key, String.valueOf(defaultValue)});
            return defaultValue;
        }
        return (T)this.getObjectOfType(key, defaultValue.getClass());
    }

    default public <T> Optional<T> getOptional(String key, Class<T> clazz) {
        Object obj = this.values().get(key);
        if (!clazz.isInstance(obj)) {
            return Optional.empty();
        }
        return Optional.of(clazz.cast(obj));
    }

    default public String getString(String key) {
        return this.getObjectOfType(key, String.class);
    }

    default public Integer getInt(String key) {
        return this.getObjectOfType(key, Integer.class);
    }

    default public Float getFloat(String key) {
        return this.getObjectOfType(key, Float.class);
    }

    default public Boolean getBoolean(String key) {
        return this.getObjectOfType(key, Boolean.class);
    }

    private List<?> getArray(String key) {
        Object obj = this.get(key);
        if (!(obj instanceof List)) {
            return null;
        }
        return (List)obj;
    }

    private <T> List<T> getArrayOfType(String key, Class<T> clazz) {
        List<?> list = this.getArray(key);
        if (list == null) {
            throw new IllegalStateException(this.identifier() + " failed to get key as " + clazz.getSimpleName() + " list: " + key);
        }
        for (Object item : list) {
            if (clazz.isInstance(item)) continue;
            throw new IllegalStateException(this.identifier() + " expected " + clazz.getSimpleName() + " but got " + item.getClass().getSimpleName() + " for item in list: " + key);
        }
        return list;
    }

    default public List<String> getArrayOfString(String key) {
        return this.getArrayOfType(key, String.class);
    }

    default public List<Integer> getArrayOfInt(String key) {
        return this.getArrayOfType(key, Integer.class);
    }

    default public List<Float> getArrayOfFloat(String key) {
        return this.getArrayOfType(key, Float.class);
    }

    default public List<Boolean> getArrayOfBoolean(String key) {
        return this.getArrayOfType(key, Boolean.class);
    }
}

