/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.events;

import java.util.List;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.recipe.HarvestingRecipe;

@EventBusSubscriber(modid="pylons", bus=EventBusSubscriber.Bus.GAME)
public class ModEventHandler {
    private ModEventHandler() {
    }

    public static void loadHarvestingRecipes(RecipeManager recipeManager) {
        List<HarvestingRecipe> harvestingRecipes = recipeManager.getAllRecipesFor(ModRegistry.HARVESTING_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        ModRegistry.HARVESTING_REGISTRY.setRecipeList(harvestingRecipes);
        Pylons.LOGGER.debug("Registered {} harvesting recipes", (Object)harvestingRecipes.size());
    }

    @SubscribeEvent
    public static void onRecipesUpdatedEvent(RecipesUpdatedEvent event) {
        Pylons.LOGGER.debug("Loading recipes on server sync");
        ModEventHandler.loadHarvestingRecipes(event.getRecipeManager());
    }

    @SubscribeEvent
    public static void onServerStartingEvent(ServerStartingEvent event) {
        if (event.getServer().isDedicatedServer()) {
            Pylons.LOGGER.debug("Loading recipes on server startup");
            ModEventHandler.loadHarvestingRecipes(event.getServer().getRecipeManager());
        }
    }
}

