/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.base;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.machines.base.DataHolder;
import net.permutated.pylons.machines.base.DataHolderClient;
import net.permutated.pylons.machines.base.DataHolderServer;
import net.permutated.pylons.network.PacketButtonClicked;

public abstract class AbstractPylonContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess containerLevelAccess;
    protected final DataHolder dataHolder;
    protected final String ownerName;
    protected final BlockPos blockPos;
    protected final boolean usesEnergy;

    protected AbstractPylonContainer(@Nullable MenuType<?> containerType, int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(containerType, windowId, playerInventory, packetBuffer, false);
    }

    protected AbstractPylonContainer(@Nullable MenuType<?> containerType, int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer, boolean usesEnergy) {
        super(containerType, windowId);
        this.usesEnergy = usesEnergy;
        this.blockPos = packetBuffer.readBlockPos();
        Level level = playerInventory.player.getCommandSenderWorld();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.containerLevelAccess = ContainerLevelAccess.create((Level)level, (BlockPos)this.blockPos);
            BlockEntity blockEntity = serverLevel.getBlockEntity(this.blockPos);
            if (blockEntity instanceof AbstractPylonTile) {
                AbstractPylonTile tile = (AbstractPylonTile)blockEntity;
                this.dataHolder = new DataHolderServer(tile);
                this.registerHandlerSlots((IItemHandler)tile.itemStackHandler);
            } else {
                Pylons.LOGGER.error("Did not find matching block entity for pos: {}", (Object)this.blockPos);
                this.dataHolder = new DataHolderClient();
            }
        } else {
            this.containerLevelAccess = ContainerLevelAccess.NULL;
            this.dataHolder = new DataHolderClient();
            this.registerHandlerSlots((IItemHandler)new ItemStackHandler(9));
        }
        this.registerPlayerSlots((IItemHandler)new InvWrapper((Container)playerInventory));
        this.registerDataSlots();
        this.dataHolder.setEnabled(packetBuffer.readInt());
        this.dataHolder.setRange(packetBuffer.readInt());
        int nameLength = packetBuffer.readInt();
        this.ownerName = packetBuffer.readUtf(nameLength);
    }

    protected abstract Supplier<Block> getBlock();

    protected int getInventorySize() {
        return 9;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Component getWorkComponent() {
        boolean shouldWork = this.dataHolder.getEnabled() == 1;
        return Component.literal((String)(shouldWork ? "On" : "Off"));
    }

    public void sendWorkPacket(Button button) {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketButtonClicked(PacketButtonClicked.ButtonType.WORK, this.blockPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean shouldRenderRange() {
        return false;
    }

    public Component getRangeComponent() {
        int range = this.dataHolder.getRange();
        return Component.literal((String)String.format("%dx%d", range, range));
    }

    public void sendRangePacket(Button button) {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketButtonClicked(PacketButtonClicked.ButtonType.RANGE, this.blockPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean stillValid(Player playerEntity) {
        return AbstractPylonContainer.stillValid((ContainerLevelAccess)this.containerLevelAccess, (Player)playerEntity, (Block)this.getBlock().get());
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        int inventorySize = this.getInventorySize();
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index < inventorySize ? !this.moveItemStackTo(stack, inventorySize, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, inventorySize, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void registerHandlerSlots(IItemHandler inventory) {
        if (this.usesEnergy) {
            return;
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlot((Slot)new SlotItemHandler(inventory, slot, 8 + slot * 18, 54));
        }
    }

    public void registerPlayerSlots(IItemHandler wrappedInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler(wrappedInventory, j + i * 9 + 9, 8 + j * 18, 90 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot((Slot)new SlotItemHandler(wrappedInventory, i, 8 + i * 18, 148));
        }
    }

    public void registerDataSlots() {
        this.addDataSlot(this.dataHolder::getRange, this.dataHolder::setRange);
        this.addDataSlot(this.dataHolder::getEnabled, this.dataHolder::setEnabled);
        this.addDataSlot(() -> this.dataHolder.getMaxEnergy() & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getMaxEnergy() & 0xFFFF0000;
            this.dataHolder.setMaxEnergy(energyStored + (value & 0xFFFF));
        });
        this.addDataSlot(() -> this.dataHolder.getMaxEnergy() >> 16 & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getMaxEnergy() & 0xFFFF;
            this.dataHolder.setMaxEnergy(energyStored | value << 16);
        });
        this.addDataSlot(() -> this.dataHolder.getEnergy() & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getEnergy() & 0xFFFF0000;
            this.dataHolder.setEnergy(energyStored + (value & 0xFFFF));
        });
        this.addDataSlot(() -> this.dataHolder.getEnergy() >> 16 & 0xFFFF, value -> {
            int energyStored = this.dataHolder.getEnergy() & 0xFFFF;
            this.dataHolder.setEnergy(energyStored | value << 16);
        });
    }

    private void addDataSlot(IntSupplier getter, IntConsumer setter) {
        this.addDataSlot(new LambdaDataSlot(getter, setter));
    }

    static class LambdaDataSlot
    extends DataSlot {
        private final IntSupplier getter;
        private final IntConsumer setter;

        public LambdaDataSlot(IntSupplier getter, IntConsumer setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public int get() {
            return this.getter.getAsInt();
        }

        public void set(int pValue) {
            this.setter.accept(pValue);
        }
    }
}

