/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class FishMountRenderer
extends EntityRenderer<FishMountEntity> {
    private final Minecraft mc = Minecraft.getInstance();

    public FishMountRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@Nonnull FishMountEntity fishMount, float entityYaw, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i) {
        super.render((Entity)fishMount, entityYaw, partialTicks, matrixStack, buffer, i);
        matrixStack.pushPose();
        Direction direction = fishMount.getDirection();
        Vec3 pos = this.getRenderOffset(fishMount, partialTicks);
        matrixStack.translate(-pos.x(), -pos.y(), -pos.z());
        double multiplier = 0.46875;
        matrixStack.translate((double)direction.getStepX() * multiplier, (double)direction.getStepY() * multiplier, (double)direction.getStepZ() * multiplier);
        matrixStack.mulPose(Axis.XP.rotationDegrees(fishMount.getXRot()));
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - fishMount.getYRot()));
        BlockRenderDispatcher rendererDispatcher = this.mc.getBlockRenderer();
        ModelManager manager = rendererDispatcher.getBlockModelShaper().getModelManager();
        matrixStack.pushPose();
        matrixStack.translate(-0.5, -0.5, -0.5);
        ResourceLocation entityTypeID = BuiltInRegistries.ENTITY_TYPE.getKey((Object)fishMount.getType());
        if (entityTypeID != null) {
            ModelResourceLocation location = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)("block/" + entityTypeID.getPath())), "standalone");
            rendererDispatcher.getModelRenderer().renderModel(matrixStack.last(), buffer.getBuffer(Sheets.solidBlockSheet()), null, manager.getModel(location), 1.0f, 1.0f, 1.0f, i, OverlayTexture.NO_OVERLAY);
        }
        matrixStack.popPose();
        this.renderFish(fishMount, matrixStack, buffer, i);
        matrixStack.popPose();
    }

    private void renderFish(FishMountEntity fishMount, PoseStack matrixStack, MultiBufferSource buffer, int i) {
        Entity entity = fishMount.entity;
        if (entity instanceof Mob) {
            Mob fish = (Mob)entity;
            double x = 0.0;
            double y = 0.0;
            double depth = 0.42;
            if (fish instanceof Pufferfish) {
                depth += 0.09;
            } else if (fish instanceof AquaFishEntity && ((AquaFishEntity)fish).getFishType().equals((Object)FishType.LONGNOSE)) {
                x = -0.1f;
                y = -0.18;
            }
            fish.setNoAi(true);
            matrixStack.translate(x, y, depth);
            matrixStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            this.mc.getEntityRenderDispatcher().render((Entity)fish, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, buffer, i);
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull FishMountEntity fishMount) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    @Nonnull
    public Vec3 getRenderOffset(FishMountEntity fishMount, float partialTicks) {
        return new Vec3((double)((float)fishMount.getDirection().getStepX() * 0.3f), -0.25, (double)((float)fishMount.getDirection().getStepZ() * 0.3f));
    }

    protected boolean shouldShowName(@Nonnull FishMountEntity fishMount) {
        if (Minecraft.renderNames() && fishMount.entity != null && this.mc.hitResult != null && fishMount.distanceToSqr(this.mc.hitResult.getLocation()) < 0.24) {
            double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)fishMount);
            float sneaking = fishMount.isDiscrete() ? 32.0f : 64.0f;
            return d0 < (double)(sneaking * sneaking);
        }
        return false;
    }

    protected void renderNameTag(@Nonnull FishMountEntity fishMount, @Nonnull Component name, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i, float partialTick) {
        super.renderNameTag((Entity)fishMount, fishMount.entity.getDisplayName(), matrixStack, buffer, i, partialTick);
        ItemStack stack = fishMount.getDisplayedItem();
        Float fishWeight = (Float)stack.get((DataComponentType)AquaDataComponents.FISH_WEIGHT.get());
        if (stack.has(AquaDataComponents.FISH_WEIGHT) && fishWeight != null) {
            float weight = fishWeight.floatValue();
            String lb = (double)weight == 1.0 ? " lb" : " lbs";
            DecimalFormat df = new DecimalFormat("#,###.##");
            BigDecimal bd = new BigDecimal(weight);
            bd = bd.round(new MathContext(3));
            matrixStack.pushPose();
            matrixStack.translate(0.0, -0.25, 0.0);
            if (bd.doubleValue() > 999.0) {
                super.renderNameTag((Entity)fishMount, (Component)Component.translatable((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{df.format((int)bd.doubleValue()) + lb}), matrixStack, buffer, i - 100, partialTick);
            } else {
                super.renderNameTag((Entity)fishMount, (Component)Component.translatable((String)"aquaculture.fishWeight.weight", (Object[])new Object[]{String.valueOf(bd) + lb}), matrixStack, buffer, i, partialTick);
            }
            matrixStack.popPose();
        }
    }
}

