/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.items.toolitems.tools;

import com.thevortex.allthemodium.entity.ThrownATMTrident;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ATMTrident
extends TridentItem
implements ProjectileItem {
    private Object renderProperties;

    public ATMTrident(Item.Properties p_43381_) {
        super(p_43381_);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 75.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    public void releaseUsing(ItemStack trident, Level level, LivingEntity thrower, int power) {
        if (thrower instanceof Player) {
            float f;
            Player player = (Player)thrower;
            int i = this.getUseDuration(trident, thrower) - power;
            if (i >= 10 && (!((f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)trident, (LivingEntity)player)) > 0.0f) || player.isInWaterOrRain())) {
                Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)trident, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                if (!level.isClientSide) {
                    trident.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)thrower.getUsedItemHand()));
                    if (f == 0.0f) {
                        ThrownATMTrident throwntrident = new ThrownATMTrident(level, player, trident);
                        throwntrident.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
                        if (player.hasInfiniteMaterials()) {
                            throwntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.addFreshEntity((Entity)throwntrident);
                        level.playSound((Player)null, (Entity)throwntrident, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.hasInfiniteMaterials()) {
                            player.getInventory().removeItem(trident);
                        }
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (f > 0.0f) {
                    float f7 = player.getYRot();
                    float f1 = player.getXRot();
                    float f2 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f1 * ((float)Math.PI / 180)));
                    float f3 = -Mth.sin((float)(f1 * ((float)Math.PI / 180)));
                    float f4 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f1 * ((float)Math.PI / 180)));
                    float f5 = Mth.sqrt((float)(f2 * f2 + f3 * f3 + f4 * f4));
                    player.push((double)(f2 *= f / f5), (double)(f3 *= f / f5), (double)(f4 *= f / f5));
                    player.startAutoSpinAttack(20, 8.0f, trident);
                    if (player.onGround()) {
                        float f6 = 1.1999999f;
                        player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    level.playSound((Player)null, (Entity)player, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level p_43405_, Player p_43406_, InteractionHand p_43407_) {
        ItemStack itemstack = p_43406_.getItemInHand(p_43407_);
        if (EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)itemstack, (LivingEntity)p_43406_) > 0.0f && !p_43406_.isInWaterOrRain()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        p_43406_.startUsingItem(p_43407_);
        return InteractionResultHolder.consume((Object)itemstack);
    }
}

