/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.neoforge;

import dev.djefrey.colorwheel.ClrwlConfig;
import dev.djefrey.colorwheel.Colorwheel;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClrwlConfigNeoForge
implements ClrwlConfig {
    public static final ClrwlConfigNeoForge INSTANCE = new ClrwlConfigNeoForge();
    public final ClientConfig client;
    private final ModConfigSpec clientSpec;

    private ClrwlConfigNeoForge() {
        Pair clientPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        this.client = (ClientConfig)clientPair.getLeft();
        this.clientSpec = (ModConfigSpec)clientPair.getRight();
        Colorwheel.CONFIG = this;
    }

    @Override
    public boolean shouldAlertIncompatiblePack() {
        return (Boolean)this.client.alertIncompatiblePack.get();
    }

    @Override
    public boolean shouldAlertBrokenPack() {
        return (Boolean)this.client.alertBrokenPack.get();
    }

    @Override
    public boolean isFallbackModeEnabled() {
        return (Boolean)this.client.fallbackModeEnabled.get();
    }

    public void registerSpecs(ModContainer context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientSpec);
    }

    public void save() {
        this.clientSpec.save();
    }

    public static class ClientConfig {
        public final ModConfigSpec.BooleanValue alertIncompatiblePack;
        public final ModConfigSpec.BooleanValue alertBrokenPack;
        public final ModConfigSpec.BooleanValue fallbackModeEnabled;

        private ClientConfig(ModConfigSpec.Builder builder) {
            this.alertIncompatiblePack = builder.comment("Should display a message when an incompatible shaderpack is used.").define("alertIncompatiblePack", true);
            this.alertBrokenPack = builder.comment("Should display a message when a broken shaderpack is used.").define("alertBrokenPack", true);
            this.fallbackModeEnabled = builder.comment("Should fallback mode be used for non supported shaderpacks.").define("enableFallbackMode", false);
        }
    }
}

