/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.gui.nbt;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.silentchaos512.lib.client.gui.nbt.DisplayNBTList;
import net.silentchaos512.lib.util.NBTToJson;
import net.silentchaos512.lib.util.TextRenderUtils;

public class DisplayNBTScreen
extends Screen {
    final List<String> lines;
    private final CompoundTag nbtCompound;
    private DisplayNBTList displayList;
    private Component header;

    public DisplayNBTScreen(CompoundTag nbt, Component titleIn) {
        super(titleIn);
        this.lines = DisplayNBTScreen.formatNbt(nbt, 0);
        this.nbtCompound = nbt;
        this.header = this.title;
    }

    protected void init() {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.getInstance();
        }
        int scaledWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int scaledHeight = this.minecraft.getWindow().getGuiScaledHeight();
        int width = 100;
        int height = 20;
        Button exportButton = Button.builder((Component)Component.literal((String)"Export to JSON"), b -> {
            JsonObject json = NBTToJson.toJsonObject(this.nbtCompound);
            String message = NBTToJson.writeFile(json);
            this.header = Component.literal((String)message);
        }).bounds(scaledWidth - width - 2, scaledHeight - height - 2, width, height).build();
        this.addRenderableWidget((GuiEventListener)exportButton);
        this.displayList = new DisplayNBTList(this, this.minecraft, scaledWidth, this.height, 12, 11);
        this.addWidget((GuiEventListener)this.displayList);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        assert (this.minecraft != null);
        this.displayList.render(graphics, mouseX, mouseY, partialTicks);
        String titleStr = this.header.getString();
        int scaledWidth = this.minecraft.getWindow().getGuiScaledWidth();
        TextRenderUtils.renderScaled(graphics, this.font, Component.literal((String)titleStr).getVisualOrderText(), (scaledWidth - this.font.width(titleStr)) / 2, 2, 1.0f, 0xFFFFFF, true);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    private static List<String> formatNbt(CompoundTag nbt, int depth) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : nbt.getAllKeys()) {
            Tag inbt = nbt.get(key);
            list.addAll(DisplayNBTScreen.formatNbt(key, inbt, depth + 1));
        }
        return list;
    }

    private static List<String> formatNbt(String key, Tag nbt, int depth) {
        ArrayList<String> list = new ArrayList<String>();
        String indentStr = DisplayNBTScreen.indent(depth);
        if (nbt instanceof CompoundTag) {
            DisplayNBTScreen.formatCompound(key, (CompoundTag)nbt, depth, list, indentStr);
        } else if (nbt instanceof CollectionTag) {
            DisplayNBTScreen.formatList(key, (CollectionTag)nbt, depth, list, indentStr);
        } else if (nbt instanceof NumericTag) {
            DisplayNBTScreen.formatNumber(key, (NumericTag)nbt, list, indentStr);
        } else if (nbt instanceof StringTag) {
            String value = nbt.getAsString();
            list.add(indentStr + DisplayNBTScreen.format(key, value, ChatFormatting.GREEN));
        }
        return list;
    }

    private static void formatCompound(String key, CompoundTag nbt, int depth, List<String> list, String indentStr) {
        if (nbt.isEmpty()) {
            list.add(indentStr + DisplayNBTScreen.format(key, "{}", ChatFormatting.RESET));
        } else {
            list.add(indentStr + DisplayNBTScreen.format(key, "{", ChatFormatting.RESET));
            list.addAll(DisplayNBTScreen.formatNbt(nbt, depth + 1));
            list.add(indentStr + "}" + (String)(key.isEmpty() ? "" : String.valueOf(ChatFormatting.DARK_GRAY) + " #" + key));
        }
    }

    private static void formatList(String key, CollectionTag nbt, int depth, List<String> list, String indentStr) {
        if (nbt.isEmpty()) {
            list.add(indentStr + DisplayNBTScreen.format(key, "[]", ChatFormatting.RESET));
        } else {
            list.add(indentStr + DisplayNBTScreen.format(key, "[", ChatFormatting.RESET));
            for (Tag element : nbt) {
                list.addAll(DisplayNBTScreen.formatNbt("", element, depth + 1));
            }
            list.add(indentStr + "]" + (String)(key.isEmpty() ? "" : String.valueOf(ChatFormatting.DARK_GRAY) + " #" + key));
        }
    }

    private static void formatNumber(String key, NumericTag nbt, List<String> list, String indentStr) {
        Number value = nbt.getAsNumber();
        String line = indentStr + DisplayNBTScreen.format(key, value, ChatFormatting.LIGHT_PURPLE);
        if (value instanceof Integer) {
            line = line + String.valueOf(ChatFormatting.GRAY) + String.format(" (0x%X)", value.intValue());
        }
        list.add(line);
    }

    private static String format(String key, Object value, ChatFormatting valueFormat) {
        if (key.isEmpty()) {
            return String.valueOf(valueFormat) + value.toString();
        }
        return String.valueOf(ChatFormatting.GOLD) + key + String.valueOf(ChatFormatting.RESET) + ": " + String.valueOf(valueFormat) + String.valueOf(value);
    }

    private static String indent(int depth) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }
}

