/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class EnumUtils {
    private EnumUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static <E extends Enum<E>> E byIndex(int value, E defaultValue, Function<E, Integer> getter) {
        for (Enum e : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
            if (getter.apply(e) != value) continue;
            return (E)e;
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> Optional<E> byIndex(int value, Class<E> clazz, Function<E, Integer> getter) {
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (getter.apply(e) != value) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static <E extends Enum<E>> E byName(String name, E defaultValue) {
        for (Enum e : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(name)) continue;
            return (E)e;
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> Optional<E> byName(String name, Class<E> clazz) {
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(name)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static <E extends Enum<E>> E byOrdinal(int ordinal, E defaultValue) {
        Enum[] enumConstants = (Enum[])defaultValue.getDeclaringClass().getEnumConstants();
        if (ordinal >= 0 && ordinal < enumConstants.length) {
            return (E)enumConstants[ordinal];
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> Optional<E> byOrdinal(int ordinal, Class<E> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        if (ordinal >= 0 && ordinal < enumConstants.length) {
            return Optional.of(enumConstants[ordinal]);
        }
        return Optional.empty();
    }

    public static <E extends Enum<E>> boolean validate(@Nullable Object obj, Class<E> enumClass) {
        if (obj != null) {
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase(obj.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static <E extends Enum<E>> E cycle(E current, boolean reverse) {
        int k = current.ordinal() + (reverse ? -1 : 1);
        int valuesCount = ((Enum[])current.getClass().getEnumConstants()).length;
        if (k < 0) {
            k = valuesCount - 1;
        } else if (k >= valuesCount) {
            k = 0;
        }
        return EnumUtils.byOrdinal(k, current);
    }
}

