/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;

public class TransientHeadlessCraftingContainer
implements CraftingContainer {
    private final NonNullList<ItemStack> items;
    private final int width;
    private final int height;

    public TransientHeadlessCraftingContainer(int width, int height) {
        this(width, height, (NonNullList<ItemStack>)NonNullList.withSize((int)(width * height), (Object)ItemStack.EMPTY));
    }

    public TransientHeadlessCraftingContainer(int width, int height, NonNullList<ItemStack> items) {
        this.items = items;
        this.width = width;
        this.height = height;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack item : this.items) {
            if (item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot >= this.getContainerSize() ? ItemStack.EMPTY : (ItemStack)this.items.get(slot);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public ItemStack removeItem(int slot, int count) {
        return ContainerHelper.removeItem(this.items, (int)slot, (int)count);
    }

    public void setItem(int slot, ItemStack itemStack) {
        this.items.set(slot, (Object)itemStack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public List<ItemStack> getItems() {
        return List.copyOf(this.items);
    }

    public void fillStackedContents(StackedContents stackedContents) {
        for (ItemStack itemStack : this.items) {
            stackedContents.accountSimpleStack(itemStack);
        }
    }
}

