/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import java.util.Optional;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CuttingBoardMenu
extends RecipeBookMenu<CraftingInput, CraftingRecipe> {
    private final CraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer resultSlots = new ResultContainer();
    private final ContainerLevelAccess access;
    private final Player player;

    public CuttingBoardMenu(int windowId, Inventory inventory) {
        this(windowId, inventory, ContainerLevelAccess.NULL);
    }

    public CuttingBoardMenu(int windowId, Inventory inventory, ContainerLevelAccess access) {
        super(MenuType.CRAFTING, windowId);
        int y;
        int x;
        this.access = access;
        this.player = inventory.player;
        this.addSlot((Slot)new ResultSlot(inventory.player, this.craftSlots, (Container)this.resultSlots, 0, 124, 35));
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 3; ++y) {
                this.addSlot(new Slot((Container)this.craftSlots, y + x * 3, 30 + y * 18, 17 + x * 18));
            }
        }
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 9; ++y) {
                this.addSlot(new Slot((Container)inventory, y + x * 9 + 9, 8 + y * 18, 84 + x * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, Player player, CraftingContainer craftingContainer, ResultContainer resultContainer) {
        if (!level.isClientSide) {
            CraftingInput recipeInput = craftingContainer.asCraftInput();
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = ItemStack.EMPTY;
            Optional optionalRecipe = level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)recipeInput, level);
            if (optionalRecipe.isPresent()) {
                ItemStack assembledStack;
                RecipeHolder recipeHolder = (RecipeHolder)optionalRecipe.get();
                CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
                if (resultContainer.setRecipeUsed(level, serverPlayer, recipeHolder) && (assembledStack = recipe.assemble((RecipeInput)recipeInput, (HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) {
                    itemStack = assembledStack;
                }
            }
            resultContainer.setItem(0, itemStack);
            menu.setRemoteSlot(0, itemStack);
            serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, menu.incrementStateId(), 0, itemStack));
        }
    }

    public void slotsChanged(Container container) {
        this.access.execute((level, pos) -> CuttingBoardMenu.slotChangedCraftingGrid((AbstractContainerMenu)this, level, this.player, this.craftSlots, this.resultSlots));
    }

    public void fillCraftSlotsStackedContents(StackedContents stackedContents) {
        this.craftSlots.fillStackedContents(stackedContents);
    }

    public void clearCraftingContent() {
        this.craftSlots.clearContent();
        this.resultSlots.clearContent();
    }

    public boolean recipeMatches(RecipeHolder<CraftingRecipe> recipe) {
        return ((CraftingRecipe)recipe.value()).matches((RecipeInput)this.craftSlots.asCraftInput(), this.player.level());
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((level, pos) -> this.clearContainer(player, (Container)this.craftSlots));
    }

    public boolean stillValid(Player player) {
        return CuttingBoardMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)ModBlocks.cuttingBoard);
    }

    public ItemStack quickMoveStack(Player player, int slotId) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotId);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotId == 0) {
                this.access.execute(($$2x, $$3x) -> slotStack.getItem().onCraftedBy(slotStack, $$2x, player));
                if (!this.moveItemStackTo(slotStack, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (slotId >= 10 && slotId < 46 ? !this.moveItemStackTo(slotStack, 1, 10, false) && (slotId < 37 ? !this.moveItemStackTo(slotStack, 37, 46, false) : !this.moveItemStackTo(slotStack, 10, 37, false)) : !this.moveItemStackTo(slotStack, 10, 46, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
            if (slotId == 0) {
                player.drop(slotStack, false);
            }
        }
        return itemStack;
    }

    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(itemStack, slot);
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return this.craftSlots.getWidth();
    }

    public int getGridHeight() {
        return this.craftSlots.getHeight();
    }

    public int getSize() {
        return 10;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot != this.getResultSlotIndex();
    }
}

