/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public abstract class DropDownList<T>
extends AbstractWidget {
    public static final int NO_SELECTION = -1;
    protected final int maxDisplayedEntries;
    protected final int baseHeight;
    protected List<T> entries;
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected boolean isOpen = false;
    protected int selected = -1;

    public DropDownList(int x, int y, int width, int height, Component narrationMsg, List<T> entries, int maxDisplayedEntries) {
        super(x, y, width, height, narrationMsg);
        this.entries = entries;
        this.maxDisplayedEntries = maxDisplayedEntries;
        this.baseHeight = height;
    }

    protected void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        int selected = this.getSelected();
        if (selected != -1) {
            this.renderEntry(gfx, this.getX(), this.getY(), mouseX, mouseY, this.entries.get(selected));
        }
        if (this.isOpen) {
            for (int i = this.startIndex; i < this.startIndex + this.maxDisplayedEntries && i < this.entries.size(); ++i) {
                this.renderEntry(gfx, this.getX(), this.getY() + this.baseHeight * (1 + i - this.startIndex), mouseX, mouseY, this.entries.get(i));
            }
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.isOpen) {
            if (this.entries.isEmpty()) {
                return;
            }
            this.isOpen = true;
            this.height = this.baseHeight * (1 + Math.min(this.entries.size(), this.maxDisplayedEntries));
        } else {
            this.selected = this.getHoveredSlot(mouseX, mouseY);
            this.height = this.baseHeight;
            this.isOpen = false;
        }
    }

    public static boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    public int getHoveredSlot(double mouseX, double mouseY) {
        if (DropDownList.isHovering(this.getX(), this.getY(), this.width, this.baseHeight, mouseX, mouseY)) {
            return this.getSelected();
        }
        if (this.isOpen) {
            for (int i = 0; i < this.maxDisplayedEntries; ++i) {
                if (this.startIndex + i >= this.entries.size() || !DropDownList.isHovering(this.getX(), this.getY() + (i + 1) * this.baseHeight, this.width, this.baseHeight, mouseX, mouseY)) continue;
                return this.startIndex + i;
            }
        }
        return -1;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int barTop = this.getX() + 14;
            int barBot = barTop + 103;
            this.scrollOffs = ((float)pMouseY - (float)barTop - 6.0f) / ((float)(barBot - barTop) - 12.0f) - 0.12f;
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - scrollY / (double)i);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.isOpen() && this.entries.size() > this.maxDisplayedEntries;
    }

    protected int getOffscreenRows() {
        return this.entries.size() - this.maxDisplayedEntries;
    }

    public int getSelected() {
        return Mth.clamp((int)this.selected, (int)-1, (int)(this.entries.size() - 1));
    }

    public void setSelected(int selected) {
        this.selected = Mth.clamp((int)selected, (int)-1, (int)(this.entries.size() - 1));
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected abstract void renderEntry(GuiGraphics var1, int var2, int var3, int var4, int var5, T var6);

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    public void setEntries(List<T> entries) {
        this.entries = entries;
        this.selected = this.entries.isEmpty() ? -1 : 0;
        this.height = this.baseHeight;
        this.startIndex = 0;
        this.isOpen = false;
    }
}

