/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.commands.RarityCommand;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class BossCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_BOSS = (ctx, builder) -> SharedSuggestionProvider.suggest(InvaderRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"spawn_boss").requires(c -> c.hasPermission(2));
        builder.then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).then(((RequiredArgumentBuilder)Commands.argument((String)"boss", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_BOSS).then(Commands.argument((String)"rarity", (ArgumentType)ResourceLocationArgument.id()).suggests(RarityCommand.SUGGEST_RARITY).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, Vec3Argument.getVec3((CommandContext)c, (String)"pos"), ResourceLocationArgument.getId((CommandContext)c, (String)"boss"), ResourceLocationArgument.getId((CommandContext)c, (String)"rarity"))))).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, Vec3Argument.getVec3((CommandContext)c, (String)"pos"), ResourceLocationArgument.getId((CommandContext)c, (String)"boss"), null)))).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, Vec3Argument.getVec3((CommandContext)c, (String)"pos"), null, null)));
        builder.then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).then(((RequiredArgumentBuilder)Commands.argument((String)"boss", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_BOSS).then(Commands.argument((String)"rarity", (ArgumentType)ResourceLocationArgument.id()).suggests(RarityCommand.SUGGEST_RARITY).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, EntityArgument.getEntity((CommandContext)c, (String)"entity").position(), ResourceLocationArgument.getId((CommandContext)c, (String)"boss"), ResourceLocationArgument.getId((CommandContext)c, (String)"rarity"))))).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, EntityArgument.getEntity((CommandContext)c, (String)"entity").position(), ResourceLocationArgument.getId((CommandContext)c, (String)"boss"), null)))).executes(c -> BossCommand.spawnBoss((CommandContext<CommandSourceStack>)c, EntityArgument.getEntity((CommandContext)c, (String)"entity").position(), null, null)));
        root.then((ArgumentBuilder)builder);
    }

    public static int spawnBoss(CommandContext<CommandSourceStack> c, Vec3 pos, @Nullable ResourceLocation bossId, @Nullable ResourceLocation rarityId) {
        Mob bossEntity;
        Invader boss;
        Player summoner;
        Entity nullableSummoner = ((CommandSourceStack)c.getSource()).getEntity();
        Player player = summoner = nullableSummoner instanceof Player ? (Player)nullableSummoner : ((CommandSourceStack)c.getSource()).getLevel().getNearestPlayer(pos.x(), pos.y(), pos.z(), 64.0, false);
        if (summoner == null) {
            ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"No available player context!"));
            return -1;
        }
        GenContext ctx = GenContext.forPlayer(summoner);
        Invader invader = boss = bossId == null ? InvaderRegistry.INSTANCE.getRandomItem(ctx) : (Invader)InvaderRegistry.INSTANCE.getValue(bossId);
        if (boss == null) {
            if (bossId != null) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Unknown boss: " + String.valueOf(bossId))));
            } else {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)"No bosses available for the current context!"));
            }
            return -2;
        }
        if (rarityId != null) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(rarityId);
            if (!rarity.isBound()) {
                ((CommandSourceStack)c.getSource()).sendFailure((Component)Component.literal((String)("Unknown rarity: " + String.valueOf(rarityId))));
                return -3;
            }
            bossEntity = boss.createBoss((ServerLevelAccessor)summoner.level(), BlockPos.containing((Position)pos), ctx, (LootRarity)rarity.get());
        } else {
            bossEntity = boss.createBoss((ServerLevelAccessor)summoner.level(), BlockPos.containing((Position)pos), ctx);
        }
        ((CommandSourceStack)c.getSource()).getLevel().addFreshEntityWithPassengers((Entity)bossEntity);
        return 0;
    }
}

