/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.modifiers.ContextualLootModifier;
import dev.shadowsoffire.apotheosis.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.util.LootPatternMatcher;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.Nullable;

public class GemLootModifier
extends ContextualLootModifier {
    public static final MapCodec<GemLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> GemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)GemTableEntry.CODEC.listOf().fieldOf("entries").forGetter(g -> g.entries)).apply((Applicative)inst, GemLootModifier::new));
    protected final List<GemTableEntry> entries;

    public GemLootModifier(LootItemCondition[] conditions, List<GemTableEntry> entries) {
        super(conditions);
        this.entries = entries;
    }

    @Override
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext ctx, GenContext gCtx) {
        for (GemTableEntry entry : this.entries) {
            Gem gem;
            if (!entry.pattern.matches(ctx.getQueriedLootTableId())) continue;
            if (!(ctx.getRandom().nextFloat() <= entry.chance())) break;
            Purity purity = Purity.random(gCtx, entry.purities);
            if (!entry.gems.isEmpty()) {
                List<WeightedEntry.Wrapper> resolved = entry.gems.stream().map(this::unwrap).filter(Objects::nonNull).map(e -> e.wrap(gCtx.tier(), gCtx.luck())).toList();
                gem = (Gem)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)ctx.getRandom(), resolved).get()).data();
            } else {
                gem = GemRegistry.INSTANCE.getRandomItem(gCtx);
            }
            if (gem == null) {
                Apotheosis.LOGGER.error("A GemLootModifier (entry {}) failed to resolve a gem for table {}!", (Object)entry.toString(), (Object)ctx.getQueriedLootTableId());
                continue;
            }
            generatedLoot.add((Object)gem.toStack(purity));
            break;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @Nullable
    private Gem unwrap(DynamicHolder<Gem> holder) {
        if (!holder.isBound()) {
            Apotheosis.LOGGER.error("A GemLootModifier failed to resolve the Gem {}!", (Object)holder.getId());
            return null;
        }
        return (Gem)holder.get();
    }

    public record GemTableEntry(LootPatternMatcher pattern, float chance, Set<DynamicHolder<Gem>> gems, Set<Purity> purities) {
        public static final Codec<GemTableEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootPatternMatcher.CODEC.fieldOf("pattern").forGetter(GemTableEntry::pattern), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(GemTableEntry::chance), (App)PlaceboCodecs.setOf((Codec)GemRegistry.INSTANCE.holderCodec()).optionalFieldOf("gems", Set.of()).forGetter(GemTableEntry::gems), (App)PlaceboCodecs.setOf(Purity.CODEC).optionalFieldOf("purities", Set.of()).forGetter(GemTableEntry::purities)).apply((Applicative)inst, GemTableEntry::new));
    }
}

