/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.cutting;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingRecipe;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class GemCuttingMenu
extends PlaceboContainerMenu {
    public static final int BASE_SLOT = 0;
    public static final int TOP_SLOT = 1;
    public static final int LEFT_SLOT = 2;
    public static final int RIGHT_SLOT = 3;
    protected final Player player;
    protected final ContainerLevelAccess access;
    protected final InternalItemHandler inv = new InternalItemHandler(this, 4){

        public int getSlotLimit(int slot) {
            return slot == 0 ? 1 : super.getSlotLimit(slot);
        }
    };
    protected final GemCuttingRecipe.CuttingRecipeInput rInput = new GemCuttingRecipe.CuttingRecipeInput((IItemHandler)this.inv);
    @Nullable
    Runnable slotChangedCallback = null;

    public GemCuttingMenu(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.NULL);
    }

    public GemCuttingMenu(int id, Inventory playerInv, ContainerLevelAccess access) {
        super(Apoth.Menus.GEM_CUTTING, id, playerInv);
        this.player = playerInv.player;
        this.access = access;
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, this.inv, 0, 62, 45, this::isValidBase));
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, this.inv, 1, 62, 12, this::isValidTop));
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, this.inv, 2, 33, 64, this::isValidLeft));
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, this.inv, 3, 90, 64, this::isValidRight));
        this.addPlayerSlots(playerInv, 8, 98);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.isValidBase((ItemStack)stack) && !this.getSlot(0).hasItem(), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.isValidTop((ItemStack)stack), 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.isValidLeft((ItemStack)stack), 2, 3);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.isValidRight((ItemStack)stack), 3, 4);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            for (RecipeHolder<GemCuttingRecipe> holder : GemCuttingMenu.getRecipes(this.level)) {
                GemCuttingRecipe r = (GemCuttingRecipe)holder.value();
                if (!r.matches((RecipeInput)this.rInput, player.level())) continue;
                ItemStack out = r.assemble((RecipeInput)this.rInput, (HolderLookup.Provider)player.level().registryAccess());
                r.decrementInputs(this.rInput, player.level());
                this.inv.setStackInSlot(0, out);
                this.level.playSound(player, player.blockPosition(), SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.5f + 0.35f * (1.0f - 2.0f * this.level.random.nextFloat()));
                Apoth.Triggers.GEM_CUTTING.trigger((ServerPlayer)player, out);
                return true;
            }
        }
        return false;
    }

    public boolean isValidBase(ItemStack stack) {
        for (RecipeHolder<GemCuttingRecipe> holder : GemCuttingMenu.getRecipes(this.level)) {
            GemCuttingRecipe r = (GemCuttingRecipe)holder.value();
            if (!r.isValidBaseItem(this.rInput, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidTop(ItemStack stack) {
        for (RecipeHolder<GemCuttingRecipe> holder : GemCuttingMenu.getRecipes(this.level)) {
            GemCuttingRecipe r = (GemCuttingRecipe)holder.value();
            if (!r.isValidTopItem(this.rInput, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidLeft(ItemStack stack) {
        for (RecipeHolder<GemCuttingRecipe> holder : GemCuttingMenu.getRecipes(this.level)) {
            GemCuttingRecipe r = (GemCuttingRecipe)holder.value();
            if (!r.isValidLeftItem(this.rInput, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidRight(ItemStack stack) {
        for (RecipeHolder<GemCuttingRecipe> holder : GemCuttingMenu.getRecipes(this.level)) {
            GemCuttingRecipe r = (GemCuttingRecipe)holder.value();
            if (!r.isValidRightItem(this.rInput, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean stillValid(Player pPlayer) {
        return (Boolean)this.access.evaluate((level, pos) -> level.getBlockState(pos).is(Apoth.Blocks.GEM_CUTTING_TABLE), (Object)true);
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((level, pos) -> this.clearContainer(pPlayer, (IItemHandler)this.inv));
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        if (this.slotChangedCallback != null) {
            this.slotChangedCallback.run();
        }
    }

    public static int getDustCost(Purity purity) {
        return 1 + purity.ordinal() * 2;
    }

    public static List<RecipeHolder<GemCuttingRecipe>> getRecipes(Level level) {
        return level.getRecipeManager().getAllRecipesFor(Apoth.RecipeTypes.GEM_CUTTING);
    }
}

