/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.placebo.config.Configuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class NameHelper {
    private static String[] names = new String[]{"Biscuit", "Elisande", "Willow", "Bippy", "Butto", "Prim", "Tyrael", "Bajorno", "Michael Morbius", "Morbius", "Arun", "Panez", "Doomsday", "Vanamar", "WhatTheDrunk", "Lothrazar", "Chelly", "Chelicia", "Darsh", "Dariush", "Cheese E Piloza", "Bing", "Royal", "NoWayHere", "SwankyStella", "Isosahedron", "Asfalis", "Biz", "Icicle", "Darko", "Shadows", "Katarina", "Faellynna", "Diliviel", "Jank", "Albert", "Andrew", "Anderson", "Andy", "Allan", "Arthur", "Aaron", "Allison", "Arielle", "Amanda", "Anne", "Annie", "Amy", "Alana", "Brandon", "Brady", "Bernard", "Ben", "Benjamin", "Bob", "Bobette", "Brooke", "Brandy", "Beatrice", "Bea", "Bella", "Becky", "Carlton", "Carl", "Calvin", "Cameron", "Carson", "Chase", "Cassandra", "Cassie", "Cas", "Carol", "Carly", "Cherise", "Charlotte", "Cheryl", "Chasity", "Danny", "Drake", "Daniel", "Derrel", "David", "Dave", "Donovan", "Don", "Donald", "Drew", "Derrick", "Darla", "Donna", "Dora", "Danielle", "Edward", "Elliot", "Ed", "Edson", "Elton", "Eddison", "Earl", "Eric", "Ericson", "Eddie", "Ediovany", "Emma", "Elizabeth", "Eliza", "Esperanza", "Esper", "Esmeralda", "Emi", "Emily", "Elaine", "Fernando", "Ferdinand", "Fred", "Feddie", "Fredward", "Frank", "Franklin", "Felix", "Felicia", "Fran", "Greg", "Gregory", "George", "Gerald", "Gina", "Geraldine", "Gabby", "Hendrix", "Henry", "Hobbes", "Herbert", "Heath", "Henderson", "Helga", "Hera", "Helen", "Helena", "Hannah", "Ike", "Issac", "Israel", "Ismael", "Irlanda", "Isabelle", "Irene", "Irenia", "Jimmy", "Jim", "Justin", "Jacob", "Jake", "Jon", "Johnson", "Jonny", "Jonathan", "Josh", "Joshua", "Julian", "Jesus", "Jericho", "Jeb", "Jess", "Joan", "Jill", "Jillian", "Jessica", "Jennifer", "Jenny", "Jen", "Judy", "Kenneth", "Kenny", "Ken", "Keith", "Kevin", "Karen", "Kassandra", "Kassie", "Leonard", "Leo", "Leroy", "Lee", "Lenny", "Luke", "Lucas", "Liam", "Lorraine", "Latasha", "Lauren", "Laquisha", "Livia", "Lydia", "Lila", "Lilly", "Lillian", "Lilith", "Lana", "Mason", "Mike", "Mickey", "Mario", "Manny", "Mark", "Marcus", "Martin", "Marty", "Matthew", "Matt", "Max", "Maximillian", "Marth", "Mia", "Marriah", "Maddison", "Maddie", "Marissa", "Miranda", "Mary", "Martha", "Melonie", "Melody", "Mel", "Minnie", "Nathan", "Nathaniel", "Nate", "Ned", "Nick", "Norman", "Nicholas", "Natasha", "Nicki", "Nora", "Nelly", "Nina", "Orville", "Oliver", "Orlando", "Owen", "Olsen", "Odin", "Olaf", "Ortega", "Olivia", "Patrick", "Pat", "Paul", "Perry", "Pinnochio", "Patrice", "Patricia", "Pennie", "Petunia", "Patti", "Pernelle", "Quade", "Quincy", "Quentin", "Quinn", "Roberto", "Robbie", "Rob", "Robert", "Roy", "Roland", "Ronald", "Richard", "Rick", "Ricky", "Rose", "Rosa", "Rhonda", "Rebecca", "Roberta", "Sparky", "Shiloh", "Stephen", "Steve", "Saul", "Sheen", "Shane", "Sean", "Sampson", "Samuel", "Sammy", "Stefan", "Sasha", "Sam", "Susan", "Suzy", "Shelby", "Samantha", "Sheila", "Sharon", "Sally", "Stephanie", "Sandra", "Sandy", "Sage", "Tim", "Thomas", "Thompson", "Tyson", "Tyler", "Tom", "Tyrone", "Timmothy", "Tamara", "Tabby", "Tabitha", "Tessa", "Tiara", "Tyra", "Uriel", "Ursala", "Uma", "Victor", "Vincent", "Vince", "Vance", "Vinny", "Velma", "Victoria", "Veronica", "Wilson", "Wally", "Wallace", "Will", "Wilard", "William", "Wilhelm", "Xavier", "Xandra", "Young", "Yvonne", "Yolanda", "Zach", "Zachary"};
    private static String[] nameParts = new String[]{"Prim", "Morb", "Ius", "Kat", "Chel", "Bing", "Darsh", "Jank", "Dark", "Osto", "Grab", "Thar", "Ger", "Ald", "Mas", "On", "O", "Din", "Thor", "Jon", "Ath", "Burb", "En", "A", "E", "I", "U", "Hab", "Bloo", "Ena", "Dit", "Aph", "Ern", "Bor", "Dav", "Id", "Toast", "Son", "For", "Wen", "Lob", "Van", "Zap", "Ear", "Ben", "Don", "Bran", "Gro", "Jen", "Bob", "Ette", "Ere", "Man", "Qua", "Bro", "Cree", "Per", "Skel", "Ton", "Zom", "Bie", "Wolf", "End", "Er", "Pig", "Sil", "Ver", "Fish", "Cow", "Chic", "Ken", "Sheep", "Squid", "Hell", "Dra", "Gor", "Nyx", "Fae", "Lux", "Vex", "Hex", "Rune", "Frost", "Flame", "Storm", "Shade", "Dawn", "Dusk", "Ash", "Mist", "Might", "Fury", "Rage", "Doom", "Grim", "Void", "Rend", "Slay", "Ar", "Or", "Ur", "El", "Al", "Im", "Un", "En", "Ix", "Ox", "Dire", "Dark", "Bright", "Swift", "Glow", "Shine", "Gleam", "Spark"};
    private static String[] prefixes = new String[]{"Dr. Michael", "Sir", "Mister", "Madam", "Doctor", "Father", "Mother", "Poppa", "Lord", "Lady", "Overseer", "Professor", "Mr.", "Mr. President", "Duke", "Duchess", "Dame", "The Honorable", "Chancellor", "Vice-Chancellor", "His Holiness", "Reverend", "Count", "Viscount", "Earl", "Captain", "Major", "General", "Senpai", "Discount"};
    private static String[] suffixes = new String[]{"Morbius", "Dragonborn", "Rejected", "Mighty", "Supreme", "Superior", "Ultimate", "Lame", "Wimpy", "Curious", "Sneaky", "Pathetic", "Crying", "Eagle", "Errant", "Unholy", "Questionable", "Mean", "Hungry", "Thirsty", "Feeble", "Wise", "Sage", "Magical", "Mythical", "Legendary", "Not Very Nice", "Jerk", "Doctor", "Misunderstood", "Angry", "Knight", "Bishop", "Godly", "Special", "Toasty", "Shiny", "Shimmering", "Light", "Dark", "Odd-Smelling", "Funky", "Rock Smasher", "Son of Herobrine", "Cracked", "Sticky", "\u00a7kAlien\u00a7r", "Baby", "Manly", "Rough", "Scary", "Undoubtable", "Honest", "Non-Suspicious", "Boring", "Odd", "Lazy", "Super", "Nifty", "Ogre Slayer", "Pig Thief", "Dirt Digger", "Really Cool", "Doominator", "... Something", "Extra-Fishy", "Gorilla Slaughterer", "Marbles Winner", "AC Rizzlord", "President", "Burger Chef", "Professional Animator", "Cheese Sprayer", "Happiness Advocate", "Ghost Hunter", "Head of Potatoes", "Ninja", "Warrior", "Pyromancer", "Trombone Player", "Airport Technician", "Grand Magistrix", "Starved", "Terrifying", "Expert Cloud Watcher", "Cookie Enthusiast", "Grass Toucher", "Coffee Addict", "Mildly Confused"};
    private static String[] helms = new String[]{"Helmet", "Cap", "Crown", "Great Helm", "Bassinet", "Sallet", "Close Helm", "Barbute"};
    private static String[] chestplates = new String[]{"Chestplate", "Tunic", "Brigandine", "Hauberk", "Cuirass"};
    private static String[] leggings = new String[]{"Leggings", "Pants", "Tassets", "Cuisses", "Schynbalds"};
    private static String[] boots = new String[]{"Boots", "Shoes", "Greaves", "Sabatons", "Sollerets"};
    private static String[] swords = new String[]{"Sword", "Cutter", "Slicer", "Dicer", "Knife", "Blade", "Machete", "Brand", "Claymore", "Cutlass", "Foil", "Dagger", "Glaive", "Rapier", "Saber", "Scimitar", "Shortsword", "Longsword", "Broadsword", "Calibur"};
    private static String[] axes = new String[]{"Axe", "Chopper", "Hatchet", "Tomahawk", "Cleaver", "Hacker", "Tree-Cutter", "Truncator"};
    private static String[] pickaxes = new String[]{"Pickaxe", "Pick", "Mattock", "Rock-Smasher", "Miner"};
    private static String[] shovels = new String[]{"Shovel", "Spade", "Digger", "Excavator", "Trowel", "Scoop"};
    private static String[] bows = new String[]{"Bow", "Shortbow", "Longbow", "Flatbow", "Recurve Bow", "Reflex Bow", "Self Bow", "Composite Bow", "Arrow-Flinger"};
    private static String[] shields = new String[]{"Shield", "Buckler", "Targe", "Greatshield", "Blockade", "Bulwark", "Tower Shield", "Protector", "Aegis"};
    private static Map<Tier, String> tierKeys = new HashMap<Tier, String>();
    private static Map<String, String[]> tierNames = new HashMap<String, String[]>();
    private static Map<ResourceKey<ArmorMaterial>, String[]> materialNames;
    public static String suffixFormat;
    public static String ownershipFormat;
    public static String chainFormat;

    public static String nameFromParts(RandomSource random) {
        String name = nameParts[random.nextInt(nameParts.length)] + nameParts[random.nextInt(nameParts.length)].toLowerCase();
        if (random.nextFloat() < 0.4f) {
            name = name + nameParts[random.nextInt(nameParts.length)].toLowerCase();
        }
        if (random.nextFloat() < 0.15f) {
            name = name + nameParts[random.nextInt(nameParts.length)].toLowerCase();
        }
        return name;
    }

    public static String setEntityName(RandomSource rand, Mob entity) {
        String root = names.length > 0 && nameParts.length > 0 ? (rand.nextFloat() < 0.45f ? names[rand.nextInt(names.length)] : NameHelper.nameFromParts(rand)) : (names.length > 0 ? names[rand.nextInt(names.length)] : NameHelper.nameFromParts(rand));
        Object name = root;
        if (rand.nextFloat() < 0.3f && prefixes.length > 0) {
            name = prefixes[rand.nextInt(prefixes.length)] + " " + (String)name;
        }
        if (rand.nextFloat() < 0.8f && suffixes.length > 0) {
            name = String.format(suffixFormat, name, suffixes[rand.nextInt(suffixes.length)]);
        }
        entity.setCustomName((Component)Component.literal((String)name));
        entity.setCustomNameVisible(true);
        return root;
    }

    public static Component setItemName(RandomSource random, ItemStack stack) {
        MutableComponent name = (MutableComponent)stack.getItem().getName(stack);
        String baseName = name.getString();
        if (stack.getItem() instanceof TieredItem) {
            Tier tier = ((TieredItem)stack.getItem()).getTier();
            String[] tierNames = NameHelper.getTierNames(tier);
            if (tierNames.length == 0) {
                String[] split = baseName.split(" ");
                Object rebuilt = "";
                for (int i = 0; i < split.length - 1; ++i) {
                    rebuilt = (String)rebuilt + split[i] + " ";
                }
                name = Component.literal((String)rebuilt);
            } else {
                name = Component.literal((String)(tierNames[random.nextInt(tierNames.length)] + " "));
            }
            String[] type = new String[]{"Tool"};
            Set types = ItemAbility.getActions().stream().filter(arg_0 -> ((ItemStack)stack).canPerformAction(arg_0)).collect(Collectors.toSet());
            if (stack.getItem() instanceof SwordItem) {
                type = swords;
            } else if (types.contains(ItemAbilities.AXE_DIG)) {
                type = axes;
            } else if (types.contains(ItemAbilities.PICKAXE_DIG)) {
                type = pickaxes;
            } else if (types.contains(ItemAbilities.SHOVEL_DIG)) {
                type = shovels;
            } else if (types.contains(ItemAbilities.SHIELD_BLOCK)) {
                type = shields;
            }
            name.append(type[random.nextInt(type.length)]);
        } else if (stack.getItem() instanceof ProjectileWeaponItem) {
            String[] type = bows;
            name = Component.literal((String)type[random.nextInt(type.length)]);
        } else if (stack.getItem() instanceof ArmorItem) {
            ResourceKey armorMat = ((ArmorItem)stack.getItem()).getMaterial().getKey();
            String[] matNames = NameHelper.getMaterialNames((ResourceKey<ArmorMaterial>)armorMat);
            if (matNames.length == 0) {
                String[] split = baseName.split(" ");
                Object rebuilt = "";
                for (int i = 0; i < split.length - 1; ++i) {
                    rebuilt = (String)rebuilt + split[i] + " ";
                }
                name = Component.literal((String)rebuilt);
            } else {
                name = Component.literal((String)(matNames[random.nextInt(matNames.length)] + " "));
            }
            String[] type = new String[]{"Armor"};
            switch (((ArmorItem)stack.getItem()).getEquipmentSlot()) {
                case HEAD: {
                    type = helms;
                    break;
                }
                case CHEST: {
                    type = chestplates;
                    break;
                }
                case LEGS: {
                    type = leggings;
                    break;
                }
                case FEET: {
                    type = boots;
                    break;
                }
            }
            name.append(type[random.nextInt(type.length)]);
        }
        stack.set(DataComponents.CUSTOM_NAME, (Object)name.withStyle(name.getStyle().withItalic(Boolean.valueOf(false))));
        return name;
    }

    public static String[] getTierNames(Tier materialName) {
        return tierNames.computeIfAbsent(NameHelper.getKey(materialName), s -> new String[0]);
    }

    public static String[] getMaterialNames(ResourceKey<ArmorMaterial> materialName) {
        return materialNames.computeIfAbsent(materialName, s -> new String[0]);
    }

    public static void load(Configuration c) {
        Tier mat;
        names = c.getStringList("Names", "entity", names, "A list of full names, which are used in the generation of boss names. May be empty only if name parts is not empty.");
        nameParts = c.getStringList("Name Parts", "entity", nameParts, "A list of name pieces, which can be spliced together to create full names.  May be empty only if names is not empty.");
        Preconditions.checkArgument((names.length != 0 || nameParts.length != 0 ? 1 : 0) != 0, (Object)"Both names and name parts are empty in apotheosis/names.cfg, this is not allowed.");
        prefixes = c.getStringList("Prefixes", "entity", prefixes, "A list of prefixes, which are used in the generation of boss names. May be empty.");
        suffixes = c.getStringList("Suffixes", "entity", suffixes, "A list of suffixes, which are used in the generation of boss names. A suffix is always preceeded by \"The\". May be empty.");
        helms = c.getStringList("Helms", "items", helms, "A list of root names for helms, used in the generation of item names. May not be empty.");
        chestplates = c.getStringList("chestplates", "items", chestplates, "A list of root names for chestplates, used in the generation of item names. May not be empty.");
        leggings = c.getStringList("leggings", "items", leggings, "A list of root names for leggings, used in the generation of item names. May not be empty.");
        boots = c.getStringList("boots", "items", boots, "A list of root names for boots, used in the generation of item names. May not be empty.");
        Preconditions.checkArgument((helms.length > 0 && chestplates.length > 0 && leggings.length > 0 && boots.length > 0 ? 1 : 0) != 0, (Object)"Detected empty lists for armor root names in apotheosis/names.cfg, this is not allowed.");
        swords = c.getStringList("swords", "items", swords, "A list of root names for swords, used in the generation of item names. May not be empty.");
        axes = c.getStringList("axes", "items", axes, "A list of root names for axes, used in the generation of item names. May not be empty.");
        pickaxes = c.getStringList("pickaxes", "items", pickaxes, "A list of root names for pickaxes, used in the generation of item names. May not be empty.");
        shovels = c.getStringList("shovels", "items", shovels, "A list of root names for shovels, used in the generation of item names. May not be empty.");
        bows = c.getStringList("bows", "items", bows, "A list of root names for bows, used in the generation of item names. May not be empty.");
        shields = c.getStringList("shields", "items", shields, "A list of root names for shields, used in the generation of item names. May not be empty.");
        Preconditions.checkArgument((swords.length > 0 && axes.length > 0 && pickaxes.length > 0 && shovels.length > 0 && bows.length > 0 ? 1 : 0) != 0, (Object)"Detected empty lists for weapon root names in apotheosis/names.cfg, this is not allowed.");
        HashMap<Tier, List> itemsByTier = new HashMap<Tier, List>();
        HashMap<ResourceKey, List> armorsByTier = new HashMap<ResourceKey, List>();
        for (Item i : BuiltInRegistries.ITEM) {
            try {
                ResourceKey key;
                if (i instanceof TieredItem) {
                    mat = ((TieredItem)i).getTier();
                    itemsByTier.computeIfAbsent(mat, m -> new ArrayList()).add(i);
                }
                if (!(i instanceof ArmorItem) || (key = ((ArmorItem)i).getMaterial().getKey()) == null) continue;
                armorsByTier.computeIfAbsent(key, m -> new ArrayList()).add(i);
            }
            catch (Exception e) {
                Apotheosis.LOGGER.error("The item {} has thrown an exception while attempting to access it's tier.", (Object)BuiltInRegistries.ITEM.getKey((Object)i));
                e.printStackTrace();
            }
        }
        for (Map.Entry e : itemsByTier.entrySet()) {
            Tier tier = (Tier)e.getKey();
            List items = (List)e.getValue();
            String key = NameHelper.getID(tier, items);
            tierKeys.put(tier, key);
            String[] read = c.getStringList(key, "tools", tierNames.getOrDefault(tier, new String[0]), NameHelper.computeComment(items, () -> ((Tier)tier).getRepairIngredient()));
            if (read.length <= 0) continue;
            tierNames.put(key, read);
        }
        for (Map.Entry e : armorsByTier.entrySet()) {
            mat = (ResourceKey)e.getKey();
            Supplier repairMat = ((ArmorMaterial)BuiltInRegistries.ARMOR_MATERIAL.get((ResourceKey)mat)).repairIngredient();
            List items = (List)e.getValue();
            String key = NameHelper.getID(mat, items);
            String[] read = c.getStringList(key, "armors", materialNames.getOrDefault(mat, new String[0]), NameHelper.computeComment(items, repairMat));
            if (read.length <= 0) continue;
            materialNames.put((ResourceKey<ArmorMaterial>)mat, read);
        }
        suffixFormat = c.getString("Suffix Format", "formatting", suffixFormat, "The format string that will be used when a suffix is applied.");
        ownershipFormat = c.getString("Ownership Format", "formatting", ownershipFormat, "The format string that will be used to indicate ownership.");
        if (c.hasChanged()) {
            c.save();
        }
    }

    private static String computeComment(List<Item> items, Supplier<Ingredient> repair) {
        Object cmt = "A list of material-based prefix names for this material group. May be empty.\n";
        cmt = (String)cmt + "Items in this group: ";
        for (Item i : items) {
            cmt = (String)cmt + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)i)) + ", ";
        }
        cmt = ((String)cmt).substring(0, ((String)cmt).length() - 2);
        return (String)cmt + "\n";
    }

    private static String getID(Object o, List<Item> items) {
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)items.get(0));
        return id.getNamespace() + "_" + id.getPath();
    }

    private static String getKey(Tier tier) {
        return tierKeys.getOrDefault(tier, "");
    }

    static {
        tierNames.put(Tiers.WOOD.name(), new String[]{"Wooden", "Wood", "Hardwood", "Balsa Wood", "Mahogany", "Plywood"});
        tierNames.put(Tiers.STONE.name(), new String[]{"Stone", "Rock", "Marble", "Cobblestone"});
        tierNames.put(Tiers.IRON.name(), new String[]{"Iron", "Steel", "Ferrous", "Rusty", "Wrought Iron"});
        tierNames.put(Tiers.GOLD.name(), new String[]{"Golden", "Gold", "Gilt", "Auric", "Ornate"});
        tierNames.put(Tiers.DIAMOND.name(), new String[]{"Diamond", "Zircon", "Gemstone", "Jewel", "Crystal"});
        tierNames.put(Tiers.NETHERITE.name(), new String[]{"Burnt", "Embered", "Fiery", "Hellborn", "Flameforged"});
        tierNames.put("twilightforest_ironwood_sword", new String[]{"Ironwood", "Earthbound", "Oaken", "Ironcapped"});
        tierNames.put("twilightforest_knightmetal_sword", new String[]{"Knightmetal", "Knightly", "Phantom-Forged"});
        tierNames.put("twilightforest_steeleaf_sword", new String[]{"Steeleaf", "Organic", "Natural", "Cobaltstem", "Tungstenpetal"});
        tierNames.put("twilightforest_fiery_sword", new String[]{"Fiery", "Flaming", "Hydra-Infused", "Infernal"});
        materialNames = new HashMap<ResourceKey<ArmorMaterial>, String[]>();
        materialNames.put((ResourceKey<ArmorMaterial>)ArmorMaterials.LEATHER.getKey(), new String[]{"Leather", "Rawhide", "Lamellar", "Cow Skin"});
        materialNames.put((ResourceKey<ArmorMaterial>)ArmorMaterials.CHAIN.getKey(), new String[]{"Chainmail", "Chain", "Chain Link", "Scale"});
        materialNames.put((ResourceKey<ArmorMaterial>)ArmorMaterials.IRON.getKey(), tierNames.get(Tiers.IRON.name()));
        materialNames.put((ResourceKey<ArmorMaterial>)ArmorMaterials.GOLD.getKey(), tierNames.get(Tiers.GOLD.name()));
        materialNames.put((ResourceKey<ArmorMaterial>)ArmorMaterials.DIAMOND.getKey(), tierNames.get(Tiers.DIAMOND.name()));
        materialNames.put((ResourceKey<ArmorMaterial>)ArmorMaterials.NETHERITE.getKey(), tierNames.get(Tiers.NETHERITE.name()));
        materialNames.put((ResourceKey<ArmorMaterial>)ArmorMaterials.TURTLE.getKey(), new String[]{"Tortollan", "Very Tragic", "Environmental", "Organic"});
        suffixFormat = "%s the %s";
        ownershipFormat = "%s's";
        chainFormat = "%s %s";
    }
}

