/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.register.RegistryItems;

public class RegistryMenuTypes {
    public static final ResourceLocation FLUX_MENU_KEY = FluxNetworks.location("flux_menu");
    public static final DeferredHolder<MenuType<?>, MenuType<FluxMenu>> FLUX_MENU = DeferredHolder.create((ResourceKey)BuiltInRegistries.MENU.key(), (ResourceLocation)FLUX_MENU_KEY);

    static void register(RegisterEvent.RegisterHelper<MenuType<?>> helper) {
        helper.register(FLUX_MENU_KEY, (Object)IMenuTypeExtension.create((containerId, inventory, buffer) -> {
            if (buffer.readBoolean()) {
                BlockPos pos = buffer.readBlockPos();
                BlockEntity patt0$temp = inventory.player.level().getBlockEntity(pos);
                if (patt0$temp instanceof TileFluxDevice) {
                    TileFluxDevice device = (TileFluxDevice)patt0$temp;
                    CompoundTag tag = buffer.readNbt();
                    if (tag != null) {
                        device.readCustomTag(tag, (byte)11);
                    }
                    return new FluxMenu(containerId, inventory, device);
                }
            } else {
                ItemStack stack = inventory.player.getMainHandItem();
                if (stack.getItem() == RegistryItems.FLUX_CONFIGURATOR.get()) {
                    return new FluxMenu(containerId, inventory, new ItemFluxConfigurator.Provider(stack));
                }
            }
            return new FluxMenu(containerId, inventory, new ItemAdminConfigurator.Provider());
        }));
    }

    private RegistryMenuTypes() {
    }
}

