/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.common.waypoint;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointImpl;
import journeymap.common.waypoint.WaypointPos;
import journeymap.common.waypoint.WaypointSettings;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class WaypointFactoryImpl
implements WaypointFactory.WaypointStore {
    public static WaypointFactoryImpl instance;
    public static WaypointFactory factory;

    public static void init() {
        instance = new WaypointFactoryImpl();
        factory = new WaypointFactory((WaypointFactory.WaypointStore)instance);
    }

    public static Waypoint createWaypoint(String modId, BlockPos blockPos, String name, String dimension, boolean showDeviation) {
        return WaypointFactoryImpl.createWaypoint(modId, blockPos, name, dimension, false, showDeviation, RGB.randomColor(), true);
    }

    public static Waypoint createWaypoint(String modId, BlockPos blockPos, String name, String dimension, int color) {
        return WaypointFactoryImpl.createWaypoint(modId, blockPos, name, dimension, false, false, color, true);
    }

    public Waypoint createClientWaypoint(String modId, BlockPos pos, @Nullable String name, String primaryDimension, boolean persistent) {
        return WaypointFactoryImpl.createWaypoint(modId, pos, name, primaryDimension, false, persistent);
    }

    public Waypoint fromWaypointJsonString(String waypoint) {
        return (Waypoint)WaypointImpl.GSON.fromJson(waypoint, ClientWaypointImpl.class);
    }

    public WaypointGroup fromGroupJsonString(String group) {
        return (WaypointGroup)WaypointImpl.GSON.fromJson(group, WaypointGroupImpl.class);
    }

    public WaypointGroup createWaypointGroup(String modId, String name) {
        return new WaypointGroupImpl(modId, name);
    }

    public WaypointGroup createWaypointGroup(String name) {
        return this.createWaypointGroup("journeymap", name);
    }

    public static Waypoint createWaypoint(String modId, BlockPos pos, @Nullable String name, String primaryDimension, boolean isDeath, boolean persistent) {
        return WaypointFactoryImpl.createWaypoint(modId, pos, name, primaryDimension, isDeath, false, RGB.randomColor(), persistent);
    }

    public static Waypoint createWaypoint(String modId, BlockPos blockPos, @Nullable String name, String primaryDimension, boolean isDeath, boolean showDeviation, int color, boolean persistent) {
        String guid = UUID.randomUUID().toString();
        if (name == null) {
            name = WaypointFactoryImpl.createName(blockPos.getX(), blockPos.getZ());
        }
        ResourceLocation icon = isDeath ? WaypointIcon.DEFAULT_ICON_DEATH : WaypointIcon.DEFAULT_ICON_NORMAL;
        String group = isDeath ? WaypointGroupStore.DEATH.getGuid() : WaypointGroupStore.DEFAULT.getGuid();
        return new ClientWaypointImpl(name, "1", modId, guid, modId, group, new WaypointPos(blockPos, primaryDimension), color, new WaypointIcon(icon), new WaypointSettings(true, showDeviation, persistent), new TreeSet<String>(Set.of(primaryDimension)), Optional.empty());
    }

    public static Waypoint createCommandWaypoint(String modId, BlockPos blockPos, @Nullable String name, String primaryDimension, boolean isDeath, boolean showDeviation, int color, boolean persistent, boolean temp) {
        String guid = UUID.randomUUID().toString();
        if (name == null) {
            name = WaypointFactoryImpl.createName(blockPos.getX(), blockPos.getZ());
        }
        ResourceLocation icon = isDeath ? WaypointIcon.DEFAULT_ICON_DEATH : WaypointIcon.DEFAULT_ICON_NORMAL;
        String group = temp ? "journeymap_temp" : "journeymap_default";
        return new WaypointImpl(name, "1", modId, guid, modId, group, new WaypointPos(blockPos, primaryDimension), color, new WaypointIcon(icon), new WaypointSettings(true, showDeviation, persistent), new TreeSet<String>(Set.of(primaryDimension)), Optional.empty());
    }

    public static void createDeathPoint(BlockPos blockPos, String dimension) {
        Date now = new Date();
        WaypointProperties properties = JourneymapClient.getInstance().getWaypointProperties();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(properties.timeFormat.get() + " " + properties.dateFormat.get());
        String timeDate = simpleDateFormat.format(now);
        String name = String.format("%s %s", Constants.getString("jm.waypoint.deathpoint"), timeDate);
        Waypoint waypoint = WaypointFactoryImpl.createWaypoint("journeymap", blockPos, name, dimension, true, true);
        WaypointStore.getInstance().save((ClientWaypointImpl)waypoint, false);
    }

    public static ClientWaypointImpl at(BlockPos blockPos, boolean isDeath, String dimension) {
        return (ClientWaypointImpl)WaypointFactoryImpl.createWaypoint("journeymap", blockPos, WaypointFactoryImpl.createName(blockPos.getX(), blockPos.getZ()), dimension, isDeath, true);
    }

    private static String createName(int x, int z) {
        return String.format("%s, %s", x, z);
    }

    public static ClientWaypointImpl of(LocalPlayer player) {
        BlockPos blockPos = new BlockPos(Mth.floor((double)player.getX()), Mth.floor((double)player.getY()), Mth.floor((double)player.getZ()));
        return WaypointFactoryImpl.at(blockPos, false, Minecraft.getInstance().player.getCommandSenderWorld().dimension().location().toString());
    }
}

