/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import java.util.ArrayList;
import java.util.HashMap;
import journeymap.client.JourneymapClientNeoForge;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.event.NeoForgeChatEvents;
import journeymap.client.event.NeoForgeChunkEvents;
import journeymap.client.event.NeoForgeClientTickEvent;
import journeymap.client.event.NeoForgeHudOverlayEvents;
import journeymap.client.event.NeoForgeLoggedInEvent;
import journeymap.client.event.NeoForgeRenderLevelStageEvent;
import journeymap.client.event.NeoForgeScreenEvents;
import journeymap.client.event.NeoForgeWorldEvent;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.neoforged.neoforge.common.NeoForge;

public class NeoForgeEventHandlerManager {
    private static HashMap<Class<? extends EventHandler>, EventHandler> handlers = new HashMap();

    public static void registerHandlers() {
        NeoForgeEventHandlerManager.register(JourneymapClientNeoForge.getInstance().getKeyEvents());
        NeoForgeEventHandlerManager.register(new NeoForgeChatEvents());
        NeoForgeEventHandlerManager.register(new NeoForgeHudOverlayEvents());
        NeoForgeEventHandlerManager.register(new NeoForgeWorldEvent());
        NeoForgeEventHandlerManager.register(new NeoForgeChunkEvents());
        NeoForgeEventHandlerManager.register(new NeoForgeClientTickEvent());
        NeoForgeEventHandlerManager.register(new NeoForgeRenderLevelStageEvent());
        NeoForgeEventHandlerManager.register(new NeoForgeLoggedInEvent());
        NeoForgeEventHandlerManager.register(new NeoForgeScreenEvents());
        ColorManager.INSTANCE.getDeclaringClass();
    }

    public static void unregisterAll() {
        ArrayList<Class<? extends EventHandler>> list = new ArrayList<Class<? extends EventHandler>>(handlers.keySet());
        for (Class<? extends EventHandler> handlerClass : list) {
            NeoForgeEventHandlerManager.unregister(handlerClass);
        }
    }

    public static void register(EventHandler handler) {
        Class<?> handlerClass = handler.getClass();
        if (handlers.containsKey(handlerClass)) {
            Journeymap.getLogger().warn("Handler already registered: " + handlerClass.getName());
            return;
        }
        try {
            NeoForge.EVENT_BUS.register((Object)handler);
            Journeymap.getLogger().debug("Handler registered: " + handlerClass.getName());
            handlers.put(handler.getClass(), handler);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(handlerClass.getName() + " registration FAILED: " + LogFormatter.toString(t));
        }
    }

    public static void unregister(Class<? extends EventHandler> handlerClass) {
        EventHandler handler = handlers.remove(handlerClass);
        if (handler != null) {
            try {
                NeoForge.EVENT_BUS.unregister((Object)handler);
                Journeymap.getLogger().debug("Handler unregistered: " + handlerClass.getName());
            }
            catch (Throwable t) {
                Journeymap.getLogger().error(String.valueOf(handler) + " unregistration FAILED: " + LogFormatter.toString(t));
            }
        }
    }

    public static HashMap<Class<? extends EventHandler>, EventHandler> getHandlers() {
        return handlers;
    }

    public static interface EventHandler {
    }
}

