/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.log;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.api.services.WebMapService;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import org.apache.logging.log4j.Level;

public class ChatLog {
    static final List<MutableComponent> announcements = Collections.synchronizedList(new LinkedList());
    public static boolean enableAnnounceMod = false;
    private static boolean initialized = false;

    public static void queueAnnouncement(Component chat) {
        MutableComponent wrap = Component.translatable((String)"jm.common.chat_announcement", (Object[])new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        MutableComponent chat = Constants.getStringTextComponent(message);
        chat.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
        chat.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Constants.getStringTextComponent(url))));
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceFile(String message, File file) {
        MutableComponent chat = Constants.getStringTextComponent(message);
        try {
            String path = file.getCanonicalPath();
            chat.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, path)));
            chat.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Constants.getStringTextComponent(path))));
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        MutableComponent chat = Constants.getStringTextComponent(text);
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement(chat);
    }

    public static void announceActionBar(Component message) {
        Minecraft.getInstance().player.displayClientMessage(message, true);
    }

    public static void announceWaypointRendering(boolean enable) {
        String key = JourneymapClient.getInstance().getKeyEvents().getHandler().kbToggleWaypointRendering.getTranslatedName().getString().toUpperCase();
        MutableComponent enabled = enable ? Component.translatable((String)"jm.common.action_bar.waypoint_rendering.toggle.enable") : Component.translatable((String)"jm.common.action_bar.waypoint_rendering.toggle.disabled");
        MutableComponent opposite = enable ? Component.translatable((String)"jm.common.action_bar.waypoint_rendering.toggle.opposite.disabled") : Component.translatable((String)"jm.common.action_bar.waypoint_rendering.toggle.opposite.enable");
        MutableComponent message = Component.translatable((String)"jm.common.action_bar.waypoint_rendering.message", (Object[])new Object[]{enabled, "\u00a7e" + key + "\u00a7f", opposite});
        ChatLog.announceActionBar((Component)message);
    }

    public static void showChatAnnouncements(Minecraft mc) {
        if (!initialized) {
            enableAnnounceMod = JourneymapClient.getInstance().getCoreProperties().announceMod.get();
            ChatLog.announceMod(enableAnnounceMod);
            VersionCheck.getVersionIsCurrent();
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Level logLevel;
            MutableComponent message = announcements.remove(0);
            if (message == null) continue;
            try {
                if (!JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue()) {
                    ChatLog.announceWaypointRendering(false);
                }
                mc.gui.getChat().addMessage((Component)message);
            }
            catch (Exception e) {
                try {
                    Journeymap.getLogger().error("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = ((TranslatableContents)message.getContents()).getArgs()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                    Journeymap.getLogger().log(logLevel2, StringUtil.stripColor((String)message.getString()));
                    throw throwable;
                }
                logLevel = ((TranslatableContents)message.getContents()).getArgs()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                Journeymap.getLogger().log(logLevel, StringUtil.stripColor((String)message.getString()));
                continue;
            }
            logLevel = ((TranslatableContents)message.getContents()).getArgs()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
            Journeymap.getLogger().log(logLevel, StringUtil.stripColor((String)message.getString()));
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod || forced) {
            String keyName = JourneymapClient.getInstance().getKeyEvents().getHandler().kbFullscreenToggle.getTranslatedName().getString().toUpperCase();
            WebMapService webServer = JourneymapClient.getInstance().getWebMap();
            if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue() && webServer != null) {
                try {
                    String port = webServer.getPort() == 80 ? "" : ":" + webServer.getPort();
                    String message = Constants.getString("jm.common.webserver_and_mapgui_ready", keyName, port);
                    ChatLog.announceURL(message, "http://localhost" + port);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Couldn't check webserver: " + LogFormatter.toString(t));
                }
            } else {
                ChatLog.announceI18N("jm.common.mapgui_only_ready", keyName);
            }
            if (!JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            }
            enableAnnounceMod = false;
        }
    }

    private static class ErrorChat
    implements Component {
        String text;

        public ErrorChat(String text) {
            this.text = text;
        }

        public Style getStyle() {
            return Style.EMPTY;
        }

        public ComponentContents getContents() {
            return PlainTextContents.create((String)this.text);
        }

        public List<Component> getSiblings() {
            return Lists.newArrayList();
        }

        public FormattedCharSequence getVisualOrderText() {
            return FormattedCharSequence.EMPTY;
        }
    }
}

