/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class ServerAdminSavePropPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"admin_save");
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerAdminSavePropPacket> STREAM_CODEC = StreamCodec.ofMember(ServerAdminSavePropPacket::encode, ServerAdminSavePropPacket::new);
    private Integer type;
    private String payload;
    private String dimension;

    public ServerAdminSavePropPacket() {
    }

    public ServerAdminSavePropPacket(Integer type, String payload, String dimension) {
        this.payload = payload;
        this.type = type;
        this.dimension = dimension;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public int getType() {
        return this.type;
    }

    public String getPayload() {
        return this.payload;
    }

    public ServerAdminSavePropPacket(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                this.type = buf.readInt();
                this.dimension = buf.readUtf(Short.MAX_VALUE);
                this.payload = buf.readUtf(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for admin save: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null && this.type != null && this.dimension != null) {
                buf.writeByte(42);
                buf.writeInt(this.type.intValue());
                buf.writeUtf(this.dimension);
                buf.writeUtf(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for admin save:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<ServerAdminSavePropPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().onServerAdminSave(ctx.sender(), ((ServerAdminSavePropPacket)ctx.message()).type, ((ServerAdminSavePropPacket)ctx.message()).payload, ((ServerAdminSavePropPacket)ctx.message()).dimension);
        }
    }
}

