/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import com.google.gson.annotations.Since;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.ApiStatus;

public class WaypointPos {
    public static MapCodec<WaypointPos> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(WaypointPos::getX), (App)Codec.INT.fieldOf("y").forGetter(WaypointPos::getY), (App)Codec.INT.fieldOf("z").forGetter(WaypointPos::getZ), (App)Codec.STRING.optionalFieldOf("dimension").forGetter(pos -> Optional.ofNullable(pos.getPrimaryDimension()))).apply((Applicative)instance, WaypointPos::new));
    @Since(value=1.0)
    protected int x;
    @Since(value=1.0)
    protected int y;
    @Since(value=1.0)
    protected int z;
    @Since(value=1.0)
    protected String primaryDimension;

    public WaypointPos(int x, int y, int z, String primaryDimension) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.primaryDimension = primaryDimension;
    }

    public WaypointPos(int x, int y, int z, Optional<String> primaryDimension) {
        this(x, y, z, (String)primaryDimension.orElse(null));
    }

    @ApiStatus.Internal
    public WaypointPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public WaypointPos(BlockPos blockPos, String primaryDimension) {
        this.x = blockPos.getX();
        this.y = blockPos.getY();
        this.z = blockPos.getZ();
        this.primaryDimension = primaryDimension;
    }

    public String getPrimaryDimension() {
        return this.primaryDimension;
    }

    public void setPrimaryDimension(String primaryDimension) {
        this.primaryDimension = primaryDimension;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public BlockPos asBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("%d~%d~%d~%s", this.x, this.y, this.z, this.primaryDimension);
    }
}

