/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.storage.MEStorage;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.lua.ObjectLuaTable;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEApi;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.MEChemicalHandler;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.MEBridgePeripheral;
import de.srendi.advancedperipherals.common.blocks.blockentities.MEBridgeEntity;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.StatusConstants;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalUtil;
import mekanism.api.chemical.IChemicalHandler;
import org.jetbrains.annotations.NotNull;

public class AEMekanismApi {
    public static MethodResult importToME(@NotNull IArguments arguments, IComputerAccess computer, MEBridgePeripheral peripheral) throws LuaException {
        MEBridgeEntity bridge = peripheral.getBridge();
        MEStorage monitor = AEApi.getMonitor(bridge.getActionableNode());
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        String side = arguments.getString(1);
        IChemicalHandler targetTank = ChemicalUtil.getHandlerFromDirection(side, peripheral.getPeripheralOwner());
        if (targetTank == null) {
            targetTank = ChemicalUtil.getHandlerFromName(computer, side);
        }
        if (targetTank == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        MEChemicalHandler chemicalHandler = new MEChemicalHandler(monitor, bridge);
        return MethodResult.of((Object)ChemicalUtil.moveChemical(targetTank, chemicalHandler, filter.getLeft()));
    }

    public static MethodResult exportToTank(@NotNull IArguments arguments, IComputerAccess computer, MEBridgePeripheral peripheral) throws LuaException {
        MEBridgeEntity bridge = peripheral.getBridge();
        MEStorage monitor = AEApi.getMonitor(bridge.getActionableNode());
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        String side = arguments.getString(1);
        IChemicalHandler targetTank = ChemicalUtil.getHandlerFromDirection(side, peripheral.getPeripheralOwner());
        if (targetTank == null) {
            targetTank = ChemicalUtil.getHandlerFromName(computer, side);
        }
        if (targetTank == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        MEChemicalHandler chemicalHandler = new MEChemicalHandler(monitor, bridge);
        return MethodResult.of((Object)ChemicalUtil.moveChemical(chemicalHandler, targetTank, filter.getLeft()));
    }
}

