/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.owner;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.FuelAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IOwnerAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.lib.LibConfig;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralCheck;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralFunction;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OperationAbility
implements IOwnerAbility,
IPeripheralPlugin {
    private final Map<String, IPeripheralOperation<?>> allowedOperations = new HashMap();
    private final IPeripheralOwner owner;
    private static final String COOLDOWNS_TAG = "cooldowns";

    public OperationAbility(IPeripheralOwner owner) {
        this.owner = owner;
    }

    protected void setCooldown(@NotNull IPeripheralOperation<?> operation, int cooldown) {
        if (cooldown > 0) {
            PatchedDataComponentMap patch;
            if (this.owner instanceof BlockEntityPeripheralOwner) {
                CompoundTag dataStorage = this.owner.getNbtStorage();
                if (!dataStorage.contains(COOLDOWNS_TAG)) {
                    dataStorage.put(COOLDOWNS_TAG, (Tag)new CompoundTag());
                }
                dataStorage.getCompound(COOLDOWNS_TAG).putLong(operation.settingsName(), Timestamp.valueOf(LocalDateTime.now().plus(cooldown, ChronoUnit.MILLIS)).getTime());
            }
            if (!(patch = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)this.owner.getDataStorage())).has((DataComponentType)DataComponents.ABILITY_COOLDOWN.get())) {
                patch.set((DataComponentType)DataComponents.ABILITY_COOLDOWN.get(), (Object)DataComponentPatch.EMPTY);
            }
            PatchedDataComponentMap operationPatch = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)((DataComponentPatch)patch.get((DataComponentType)DataComponents.ABILITY_COOLDOWN.get())));
            operationPatch.set(operation.dataComponentType(), (Object)cooldown);
            patch.set((DataComponentType)DataComponents.ABILITY_COOLDOWN.get(), (Object)operationPatch.asPatch());
            this.owner.putDataStorage(patch.asPatch());
        }
    }

    protected int getCooldown(@NotNull IPeripheralOperation<?> operation) {
        if (this.owner instanceof BlockEntityPeripheralOwner) {
            String operationName;
            CompoundTag dataStorage = this.owner.getNbtStorage();
            if (!dataStorage.contains(COOLDOWNS_TAG)) {
                return 0;
            }
            CompoundTag cooldowns = dataStorage.getCompound(COOLDOWNS_TAG);
            if (!cooldowns.contains(operationName = operation.settingsName())) {
                return 0;
            }
            long currentTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
            return (int)Math.max(0L, cooldowns.getLong(operationName) - currentTime);
        }
        PatchedDataComponentMap patch = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)this.owner.getDataStorage());
        if (!patch.has((DataComponentType)DataComponents.ABILITY_COOLDOWN.get())) {
            patch.set((DataComponentType)DataComponents.ABILITY_COOLDOWN.get(), (Object)DataComponentPatch.EMPTY);
            this.owner.putDataStorage(patch.asPatch());
        }
        if (((DataComponentPatch)patch.get((DataComponentType)DataComponents.ABILITY_COOLDOWN.get())).isEmpty()) {
            return 0;
        }
        DataComponentPatch cooldowns = (DataComponentPatch)patch.get((DataComponentType)DataComponents.ABILITY_COOLDOWN.get());
        if (cooldowns.get(operation.dataComponentType()).isEmpty()) {
            return 0;
        }
        long currentTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return (int)Math.max(0L, (Long)cooldowns.get(operation.dataComponentType()).get() - currentTime);
    }

    public void registerOperation(@NotNull IPeripheralOperation<?> operation) {
        int initialCooldown;
        this.allowedOperations.put(operation.settingsName(), operation);
        if (LibConfig.initialCooldownEnabled && (initialCooldown = operation.getInitialCooldown()) >= LibConfig.initialCooldownSensitivity) {
            this.setCooldown(operation, initialCooldown);
        }
    }

    @NotNull
    public <T> MethodResult performOperation(IPeripheralOperation<T> operation, T context, @Nullable IPeripheralCheck<T> check, IPeripheralFunction<T, MethodResult> method, @Nullable Consumer<T> successCallback, @Nullable BiConsumer<MethodResult, FailReason> failCallback) throws LuaException {
        MethodResult checkResult;
        if (this.isOnCooldown(operation)) {
            MethodResult result = MethodResult.of((Object[])new Object[]{null, String.format("%s is on cooldown", operation.settingsName())});
            if (failCallback != null) {
                failCallback.accept(result, FailReason.COOLDOWN);
            }
            return result;
        }
        if (check != null && (checkResult = check.check(context)) != null) {
            if (failCallback != null) {
                failCallback.accept(checkResult, FailReason.CHECK_FAILED);
            }
            return checkResult;
        }
        int cost = operation.getCost(context);
        int cooldown = operation.getCooldown(context);
        if (cost != 0) {
            FuelAbility<?> fuelAbility = this.owner.getAbility(PeripheralOwnerAbility.FUEL);
            if (fuelAbility == null) {
                MethodResult result = MethodResult.of((Object[])new Object[]{null, "This peripheral has no fuel at all"});
                if (failCallback != null) {
                    failCallback.accept(result, FailReason.NOT_ENOUGH_FUEL);
                }
                return result;
            }
            if (!fuelAbility.consumeFuel(cost, false)) {
                MethodResult result = MethodResult.of((Object[])new Object[]{null, "Not enough fuel for operation"});
                if (failCallback != null) {
                    failCallback.accept(result, FailReason.NOT_ENOUGH_FUEL);
                }
                return result;
            }
            cooldown = fuelAbility.reduceCooldownAccordingToConsumptionRate(cooldown);
        }
        MethodResult result = method.apply(context);
        if (successCallback != null) {
            successCallback.accept(context);
        }
        this.setCooldown(operation, cooldown);
        return result;
    }

    public int getCurrentCooldown(IPeripheralOperation<?> operation) {
        return this.getCooldown(operation);
    }

    public boolean isOnCooldown(IPeripheralOperation<?> operation) {
        return this.getCurrentCooldown(operation) > 0;
    }

    @Override
    public void collectConfiguration(Map<String, Object> dict) {
        for (IPeripheralOperation<?> operation : this.allowedOperations.values()) {
            dict.put(operation.settingsName(), operation.computerDescription());
        }
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getOperationCooldown(String name) {
        IPeripheralOperation<?> op = this.allowedOperations.get(name);
        if (op == null) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot find this operation"});
        }
        return MethodResult.of((Object)this.getCurrentCooldown(op));
    }

    public static enum FailReason {
        COOLDOWN,
        NOT_ENOUGH_FUEL,
        CHECK_FAILED;

    }
}

