/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.owner;

import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.FuelAbility;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class TileEntityFuelAbility<T extends BlockEntity>
extends FuelAbility<BlockEntityPeripheralOwner<T>> {
    public TileEntityFuelAbility(@NotNull BlockEntityPeripheralOwner<T> owner) {
        super(owner);
    }

    @Override
    protected boolean consumeFuel(int count) {
        IEnergyStorage energyStorage = (IEnergyStorage)((BlockEntityPeripheralOwner)this.owner).getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, ((BlockEntityPeripheralOwner)this.owner).getPos(), null);
        if (energyStorage != null) {
            int energyCount = count * (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get();
            int extractedCount = energyStorage.extractEnergy(energyCount, true);
            if (extractedCount == energyCount) {
                energyStorage.extractEnergy(energyCount, false);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected int getMaxFuelConsumptionRate() {
        return 1;
    }

    @Override
    public boolean isFuelConsumptionDisable() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enablePoweredPeripherals.get() == false;
    }

    @Override
    public int getFuelCount() {
        IEnergyStorage energyStorage = (IEnergyStorage)((BlockEntityPeripheralOwner)this.owner).getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, ((BlockEntityPeripheralOwner)this.owner).getPos(), null);
        if (energyStorage != null) {
            return energyStorage.getEnergyStored() / (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get();
        }
        return 0;
    }

    @Override
    public int getFuelMaxCount() {
        IEnergyStorage energyStorage = (IEnergyStorage)((BlockEntityPeripheralOwner)this.owner).getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, ((BlockEntityPeripheralOwner)this.owner).getPos(), null);
        if (energyStorage != null) {
            return energyStorage.getEnergyStored() / (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get();
        }
        return 0;
    }

    @Override
    public void addFuel(int count) {
        IEnergyStorage energyStorage = (IEnergyStorage)((BlockEntityPeripheralOwner)this.owner).getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, ((BlockEntityPeripheralOwner)this.owner).getPos(), null);
        if (energyStorage != null) {
            energyStorage.receiveEnergy(count * (Integer)APConfig.METAPHYSICS_CONFIG.energyToFuelRate.get(), false);
        }
    }
}

