/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items.base;

import de.srendi.advancedperipherals.client.KeyBindings;
import de.srendi.advancedperipherals.common.items.base.IInventoryItem;
import de.srendi.advancedperipherals.common.util.EnumColor;
import de.srendi.advancedperipherals.common.util.KeybindUtil;
import de.srendi.advancedperipherals.common.util.TranslationUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class BaseItem
extends Item {
    private Component description;

    public BaseItem(Item.Properties properties) {
        super(properties);
    }

    public BaseItem() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        if (worldIn.isClientSide) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.getItemInHand(handIn));
        }
        BaseItem baseItem = this;
        if (baseItem instanceof IInventoryItem) {
            IInventoryItem inventoryItem = (IInventoryItem)((Object)baseItem);
            ServerPlayer serverPlayerEntity = (ServerPlayer)playerIn;
            ItemStack stack = playerIn.getItemInHand(handIn);
            serverPlayerEntity.openMenu(inventoryItem.createContainer(playerIn, stack), buf -> ItemStack.STREAM_CODEC.encode(buf, (Object)stack));
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (!KeybindUtil.isKeyPressed(KeyBindings.DESCRIPTION_KEYBINDING)) {
            tooltip.add(EnumColor.buildTextComponent((Component)Component.translatable((String)"item.advancedperipherals.tooltip.show_desc", (Object[])new Object[]{KeyBindings.DESCRIPTION_KEYBINDING.getTranslatedKeyMessage()})));
        } else {
            tooltip.add(EnumColor.buildTextComponent(this.getDescription()));
        }
        if (!this.isEnabled()) {
            tooltip.add(EnumColor.buildTextComponent((Component)Component.translatable((String)"item.advancedperipherals.tooltip.disabled")));
        }
    }

    @NotNull
    public Component getDescription() {
        if (this.description == null) {
            this.description = TranslationUtil.itemTooltip(this.getDescriptionId());
        }
        return this.description;
    }

    public abstract boolean isEnabled();
}

