/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.util.DataComponentUtil;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.GenericFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemFilter
extends GenericFilter<ItemStack> {
    public static final ItemFilter EMPTY = new ItemFilter();
    private Item item = Items.AIR;
    private TagKey<Item> tag = null;
    private Tag componentsAsNbt = null;
    private PatchedDataComponentMap components;
    private int count = 64;
    private String fingerprint = "";
    public int fromSlot = -1;
    public int toSlot = -1;

    private ItemFilter() {
    }

    public static Pair<ItemFilter, String> parse(LuaTable<?, ?> item) {
        if (item.isEmpty()) {
            return Pair.of(EMPTY, null);
        }
        ItemFilter itemFilter = ItemFilter.createEmpty();
        if (item.containsKey((Object)"name")) {
            try {
                String name = item.getString("name");
                if (name.startsWith("#")) {
                    itemFilter.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)name.substring(1)));
                } else {
                    itemFilter.item = (Item)ItemUtil.getRegistryEntry(name, BuiltInRegistries.ITEM);
                    if (itemFilter.item == null) {
                        return Pair.of(null, "ITEM_NOT_FOUND");
                    }
                }
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_ITEM");
            }
        }
        if (item.containsKey((Object)"components")) {
            try {
                itemFilter.componentsAsNbt = NBTUtil.fromText(item.getString("components"));
            }
            catch (LuaException luaException) {
                try {
                    itemFilter.componentsAsNbt = NBTUtil.fromText(item.getTable("components").toString());
                }
                catch (LuaException e) {
                    return Pair.of(null, "NO_VALID_COMPONENTS");
                }
            }
        }
        if (item.containsKey((Object)"fingerprint")) {
            try {
                itemFilter.fingerprint = item.getString("fingerprint");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FINGERPRINT");
            }
        }
        if (item.containsKey((Object)"fromSlot")) {
            try {
                itemFilter.fromSlot = item.getInt("fromSlot");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FROMSLOT");
            }
        }
        if (item.containsKey((Object)"toSlot")) {
            try {
                itemFilter.toSlot = item.getInt("toSlot");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_TOSLOT");
            }
        }
        if (item.containsKey((Object)"count")) {
            try {
                itemFilter.count = item.getInt("count");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_COUNT");
            }
        }
        AdvancedPeripherals.debug("Parsed item filter: " + String.valueOf(itemFilter));
        return Pair.of(itemFilter, null);
    }

    public static ItemFilter fromStack(ItemStack stack) {
        ItemFilter filter = ItemFilter.createEmpty();
        filter.item = stack.getItem();
        filter.componentsAsNbt = DataComponentUtil.toNbt(stack.getComponentsPatch());
        filter.components = (PatchedDataComponentMap)stack.getComponents();
        return filter;
    }

    public static ItemFilter createEmpty() {
        return new ItemFilter();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY || this.fingerprint.isEmpty() && this.item == Items.AIR && this.tag == null && this.componentsAsNbt == null;
    }

    @Override
    public boolean testAE(GenericStack genericStack) {
        if (!APAddon.AE2.isLoaded()) {
            return false;
        }
        AEKey aEKey = genericStack.what();
        if (aEKey instanceof AEItemKey) {
            AEItemKey aeItemKey = (AEItemKey)aEKey;
            return this.test(aeItemKey.toStack());
        }
        return false;
    }

    @Override
    public boolean testRS(ResourceAmount resourceAmount) {
        if (!APAddon.REFINEDSTORAGE.isLoaded()) {
            return false;
        }
        com.refinedmods.refinedstorage.api.resource.ResourceKey resourceKey = resourceAmount.resource();
        if (resourceKey instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resourceKey;
            return this.test(itemResource.toItemStack(1L));
        }
        return false;
    }

    public ItemStack toItemStack() {
        ItemStack result = new ItemStack((ItemLike)this.item, this.count);
        if (this.components != null) {
            result.applyComponents((DataComponentMap)this.components);
        }
        return result;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.isEmpty()) {
            return true;
        }
        if (!this.fingerprint.isEmpty()) {
            String testFingerprint = ItemUtil.getFingerprint(stack);
            return this.fingerprint.equals(testFingerprint);
        }
        if (this.item != Items.AIR && !stack.is(this.item)) {
            return false;
        }
        if (this.tag != null && !stack.is(this.tag)) {
            return false;
        }
        return this.componentsAsNbt == null || DataComponentUtil.toNbt(stack.getComponentsPatch()).equals((Object)this.componentsAsNbt);
    }

    public int getCount() {
        return this.count;
    }

    public Item getItem() {
        return this.item;
    }

    public int getFromSlot() {
        return this.fromSlot;
    }

    public int getToSlot() {
        return this.toSlot;
    }

    public Tag getComponentsAsNbt() {
        return this.componentsAsNbt;
    }

    public String toString() {
        return "ItemFilter{item=" + String.valueOf(ItemUtil.getRegistryKey(this.item)) + ", tag=" + String.valueOf(this.tag) + ", components=" + String.valueOf(this.componentsAsNbt) + ", count=" + this.count + ", fingerprint='" + this.fingerprint + "', fromSlot=" + this.fromSlot + ", toSlot=" + this.toSlot + "}";
    }
}

