/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network.toserver;

import com.mojang.authlib.GameProfile;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.network.APNetworking;
import de.srendi.advancedperipherals.network.IAPPacket;
import de.srendi.advancedperipherals.network.toclient.UsernameToCachePacket;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class RetrieveUsernamePacket
implements IAPPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, RetrieveUsernamePacket> CODEC = StreamCodec.of((buffer, value) -> value.write((FriendlyByteBuf)buffer), RetrieveUsernamePacket::decode);
    public static final CustomPacketPayload.Type<RetrieveUsernamePacket> TYPE = new CustomPacketPayload.Type(AdvancedPeripherals.getRL("retrieveusername"));
    public UUID uuid;
    public UUID requester;

    public RetrieveUsernamePacket(UUID uuid, UUID requester) {
        this.uuid = uuid;
        this.requester = requester;
    }

    public static RetrieveUsernamePacket decode(FriendlyByteBuf buffer) {
        return new RetrieveUsernamePacket(buffer.readUUID(), buffer.readUUID());
    }

    @Override
    public void handle(IPayloadContext context) {
        Optional gameProfile = ServerLifecycleHooks.getCurrentServer().getProfileCache().get(this.uuid);
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(this.requester);
        if (player == null) {
            return;
        }
        if (gameProfile.isEmpty()) {
            return;
        }
        APNetworking.sendTo(player, new UsernameToCachePacket(((GameProfile)gameProfile.get()).getId(), ((GameProfile)gameProfile.get()).getName()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.requester);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

