/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.drone;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public interface IProgWidget {
    @ApiStatus.NonExtendable
    public int getX();

    @ApiStatus.NonExtendable
    public int getY();

    @ApiStatus.NonExtendable
    public void setX(int var1);

    @ApiStatus.NonExtendable
    public void setY(int var1);

    @ApiStatus.NonExtendable
    default public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public int getWidth();

    public int getHeight();

    public ResourceLocation getTexture();

    @ApiStatus.NonExtendable
    public Pair<Float, Float> getMaxUV();

    public void getTooltip(List<Component> var1);

    public void addWarnings(List<Component> var1, List<IProgWidget> var2);

    public void addErrors(List<Component> var1, List<IProgWidget> var2);

    public boolean hasStepInput();

    public boolean hasStepOutput();

    default public boolean freeToUse() {
        return false;
    }

    public ProgWidgetType<?> getType();

    public Goal getWidgetAI(IDrone var1, IProgWidget var2);

    public Goal getWidgetTargetAI(IDrone var1, IProgWidget var2);

    public void setOutputWidget(IProgWidget var1);

    public IProgWidget getOutputWidget();

    public IProgWidget getOutputWidget(IDrone var1, List<IProgWidget> var2);

    public ProgWidgetType<?> returnType();

    @Nonnull
    public List<ProgWidgetType<?>> getParameters();

    @ApiStatus.NonExtendable
    public void setParameter(int var1, IProgWidget var2);

    public boolean canSetParameter(int var1);

    @ApiStatus.NonExtendable
    public IProgWidget[] getConnectedParameters();

    @ApiStatus.NonExtendable
    public void setParent(IProgWidget var1);

    @ApiStatus.NonExtendable
    public IProgWidget getParent();

    @ApiStatus.NonExtendable
    public ResourceLocation getTypeID();

    @ApiStatus.NonExtendable
    default public String getTranslationKey() {
        String s = this.getTypeID().toString().replace(':', '.');
        return "programmingPuzzle." + s + ".name";
    }

    public DyeColor getColor();

    public boolean isAvailable();

    public IProgWidget copyWidget();

    public boolean canBeRunByComputers(IDrone var1, IProgWidget var2);

    @ApiStatus.NonExtendable
    default public boolean isDifficultyOK(WidgetDifficulty difficulty) {
        return this.getDifficulty().isNotMoreDifficult(difficulty);
    }

    public WidgetDifficulty getDifficulty();

    @Nonnull
    public List<Component> getExtraStringInfo();

    public static IProgWidget create(ProgWidgetType<?> type) {
        return type.create();
    }

    public static enum WidgetDifficulty {
        EASY("easy", 0),
        MEDIUM("medium", 1),
        ADVANCED("advanced", 2);

        private final String name;
        private final int difficultyLevel;

        private WidgetDifficulty(String name, int difficultyLevel) {
            this.name = name;
            this.difficultyLevel = difficultyLevel;
        }

        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.difficulty." + this.name;
        }

        public String getTooltipTranslationKey() {
            return "pneumaticcraft.gui.programmer.difficulty." + this.name + ".tooltip";
        }

        public boolean isNotMoreDifficult(WidgetDifficulty other) {
            return this.difficultyLevel <= other.difficultyLevel;
        }
    }
}

