/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.ClientSetup;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.model.CamoModel;
import me.desht.pneumaticcraft.client.model.custom.CamouflageModel;
import me.desht.pneumaticcraft.client.model.custom.FluidItemModel;
import me.desht.pneumaticcraft.client.model.custom.RenderedItemModel;
import me.desht.pneumaticcraft.client.model.custom.pressure_tube.PressureTubeModelLoader;
import me.desht.pneumaticcraft.client.render.MinigunItemRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticArmorLayerColors;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.fluid.FluidBiodiesel;
import me.desht.pneumaticcraft.common.fluid.FluidDiesel;
import me.desht.pneumaticcraft.common.fluid.FluidEtchingAcid;
import me.desht.pneumaticcraft.common.fluid.FluidEthanol;
import me.desht.pneumaticcraft.common.fluid.FluidGasoline;
import me.desht.pneumaticcraft.common.fluid.FluidKerosene;
import me.desht.pneumaticcraft.common.fluid.FluidLPG;
import me.desht.pneumaticcraft.common.fluid.FluidLubricant;
import me.desht.pneumaticcraft.common.fluid.FluidMemoryEssence;
import me.desht.pneumaticcraft.common.fluid.FluidOil;
import me.desht.pneumaticcraft.common.fluid.FluidPlastic;
import me.desht.pneumaticcraft.common.fluid.FluidVegetableOil;
import me.desht.pneumaticcraft.common.fluid.FluidYeastCulture;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ModClientEventHandler {
    @SubscribeEvent
    public static void onModelBaking(ModelEvent.ModifyBakingResult event) {
        for (DeferredHolder block : ModBlocks.BLOCKS.getEntries()) {
            if (!(block.get() instanceof AbstractCamouflageBlock)) continue;
            for (BlockState state : ((Block)block.get()).getStateDefinition().getPossibleStates()) {
                ModelResourceLocation loc = BlockModelShaper.stateToModelLocation((BlockState)state);
                BakedModel model = (BakedModel)event.getModels().get(loc);
                if (model == null) continue;
                event.getModels().put(loc, new CamoModel(model));
            }
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelEvent.RegisterGeometryLoaders event) {
        event.register(PneumaticRegistry.RL("camouflaged"), (IGeometryLoader)CamouflageModel.Loader.INSTANCE);
        event.register(PneumaticRegistry.RL("fluid_container_item"), (IGeometryLoader)FluidItemModel.Loader.INSTANCE);
        event.register(PneumaticRegistry.RL("rendered_item"), (IGeometryLoader)RenderedItemModel.Loader.INSTANCE);
        event.register(PneumaticRegistry.RL("pressure_tube"), (IGeometryLoader)PressureTubeModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        Block[] toAdd = (Block[])ModBlocks.BLOCKS.getEntries().stream().filter(h -> h.get() instanceof AbstractPneumaticCraftBlock).map(DeferredHolder::get).toArray(Block[]::new);
        event.registerBlock(ClientSetup.PARTICLE_HANDLER, toAdd);
        event.registerItem((IClientItemExtensions)MinigunItemRenderer.RenderProperties.INSTANCE, new Item[]{(Item)ModItems.MINIGUN.get()});
        for (ItemStack stack : ArmorMainScreen.ARMOR_STACKS) {
            event.registerItem((IClientItemExtensions)PneumaticArmorLayerColors.INSTANCE, new Item[]{stack.getItem()});
        }
        event.registerFluidType((IClientFluidTypeExtensions)FluidOil.RENDER_PROPS, new FluidType[]{ModFluids.OIL_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidBiodiesel.RENDER_PROPS, new FluidType[]{ModFluids.BIODIESEL_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidDiesel.RENDER_PROPS, new FluidType[]{ModFluids.DIESEL_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidEtchingAcid.RENDER_PROPS, new FluidType[]{ModFluids.ETCHING_ACID_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidEthanol.RENDER_PROPS, new FluidType[]{ModFluids.ETHANOL_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidGasoline.RENDER_PROPS, new FluidType[]{ModFluids.GASOLINE_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidKerosene.RENDER_PROPS, new FluidType[]{ModFluids.KEROSENE_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidLPG.RENDER_PROPS, new FluidType[]{ModFluids.LPG_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidLubricant.RENDER_PROPS, new FluidType[]{ModFluids.LUBRICANT_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidMemoryEssence.RENDER_PROPS, new FluidType[]{ModFluids.MEMORY_ESSENCE_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidPlastic.RENDER_PROPS, new FluidType[]{ModFluids.PLASTIC_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidVegetableOil.RENDER_PROPS, new FluidType[]{ModFluids.VEGETABLE_OIL_FLUID_TYPE.get()});
        event.registerFluidType((IClientFluidTypeExtensions)FluidYeastCulture.RENDER_PROPS, new FluidType[]{ModFluids.YEAST_CULTURE_FLUID_TYPE.get()});
    }
}

