/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.IExtraGuiHandling;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.MinigunMagazineMenu;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;

public class MinigunMagazineScreen
extends AbstractPneumaticCraftContainerScreen<MinigunMagazineMenu, AbstractPneumaticCraftBlockEntity>
implements IExtraGuiHandling {
    private int lockedSlot = -1;

    public MinigunMagazineScreen(MinigunMagazineMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.addInfoTab(GuiUtils.xlateAndSplit("gui.tooltip.item.pneumaticcraft.minigun", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.minigun.slotInfo.title", new Object[0]), new ItemStack((ItemLike)ModItems.GUN_AMMO.get()), -16744256, true).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.minigun.slotInfo", ClientUtils.translateKeyBind(Minecraft.getInstance().options.keyPickItem)));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_MINIGUN_MAGAZINE;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        ItemStack gunStack = Minecraft.getInstance().player.getItemInHand(((MinigunMagazineMenu)this.menu).getHand());
        if (gunStack.getItem() instanceof MinigunItem) {
            this.lockedSlot = MinigunItem.getLockedSlot(gunStack);
        }
    }

    @Override
    public void drawExtras(ContainerScreenEvent.Render.Foreground event) {
        if (this.lockedSlot >= 0) {
            int minX = 26 + this.lockedSlot % 2 * 18;
            int minY = 26 + this.lockedSlot / 2 * 18;
            event.getGuiGraphics().fill(minX, minY, minX + 16, minY + 16, 838914048);
            event.getGuiGraphics().hLine(minX, minX + 16, minY, -16723968);
            event.getGuiGraphics().hLine(minX, minX + 16, minY + 16, -16723968);
            event.getGuiGraphics().vLine(minX, minY, minY + 16, -16723968);
            event.getGuiGraphics().vLine(minX + 16, minY, minY + 16, -16723968);
        }
    }
}

