/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BulletParticle
extends TextureSheetParticle {
    public BulletParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.gravity = 0.0f;
        this.lifetime = 30;
        this.friction = 0.0f;
        this.hasPhysics = false;
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.pickSprite(spriteSet);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        BlockState state = this.level.getBlockState(pos);
        if (!state.getCollisionShape((BlockGetter)this.level, pos).isEmpty() || this.onGround) {
            ClipContext ctx;
            BlockHitResult res;
            if (this.level.random.nextBoolean() && (res = this.level.clip(ctx = new ClipContext(new Vec3(this.x, this.y, this.z), new Vec3(this.x + this.xd, this.y + this.yd, this.z + this.zd), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()))).getType() == HitResult.Type.BLOCK) {
                Direction face = res.getDirection();
                this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), this.x, this.y, this.z, (double)face.getStepX() * 0.2, (double)face.getStepY() * 0.2, (double)face.getStepZ() * 0.2);
            }
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BulletParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

