/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import me.desht.pneumaticcraft.api.client.IChargingStationRenderOverride;
import me.desht.pneumaticcraft.client.ClientRegistryImpl;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChargingStationRenderer
implements BlockEntityRenderer<ChargingStationBlockEntity> {
    public ChargingStationRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ChargingStationBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack renderStack = te.getChargingStackSynced();
        if (renderStack.isEmpty() || !te.nonNullLevel().isLoaded(te.getBlockPos()) || te.getCamouflage() != null) {
            return;
        }
        matrixStackIn.pushPose();
        IChargingStationRenderOverride override = ClientRegistryImpl.getInstance().getChargingRenderOverride((ItemLike)renderStack.getItem());
        if (override.onRender(matrixStackIn, renderStack, partialTicks, bufferIn, combinedLightIn, combinedOverlayIn)) {
            matrixStackIn.translate(0.5, 0.5, 0.5);
            RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
            if (!(renderStack.getItem() instanceof BlockItem)) {
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            }
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel bakedModel = itemRenderer.getModel(renderStack, te.getLevel(), null, 0);
            itemRenderer.render(renderStack, ItemDisplayContext.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedModel);
        }
        matrixStackIn.popPose();
    }
}

