/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.drone;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.model.entity.drone.ModelDrone;
import me.desht.pneumaticcraft.client.render.entity.drone.RenderDrone;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;

public class DroneHeldItemLayer
extends RenderLayer<AbstractDroneEntity, ModelDrone> {
    DroneHeldItemLayer(RenderDrone renderer) {
        super((RenderLayerParent)renderer);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, AbstractDroneEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack held = entityIn.getDroneHeldItem();
        if (!(held.isEmpty() || held.getItem() instanceof AbstractGunAmmoItem && entityIn.hasMinigun())) {
            this.renderHeldItem(held, matrixStackIn, bufferIn, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entityIn, (float)0.0f), entityIn.level());
        }
    }

    private void renderHeldItem(@Nonnull ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int packedOverlay, Level level) {
        matrixStack.pushPose();
        matrixStack.translate(0.0, 1.5, 0.0);
        if (!(stack.getItem() instanceof DiggerItem || stack.getItem() instanceof SwordItem || stack.getItem() instanceof HoeItem)) {
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        }
        float scaleFactor = stack.getItem() instanceof BlockItem ? 0.7f : 0.5f;
        matrixStack.scale(scaleFactor, scaleFactor, scaleFactor);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, matrixStack, buffer, level, 0);
        matrixStack.popPose();
    }
}

