/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tube_module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.common.tubemodules.ChargingModule;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class ChargingRenderer
extends AbstractTubeModuleRenderer<ChargingModule> {
    private final ModelPart tip;
    private final ModelPart body;
    private final ModelPart tubeConnector;
    private final ModelPart tipBottom;
    private final ModelPart tipTop;
    private final ModelPart tipRight;
    private final ModelPart tipLeft;
    private static final String TIP = "tip";
    private static final String BODY = "body";
    private static final String TUBECONNECTOR = "tubeConnector";
    private static final String TIPBOTTOM = "tipBottom";
    private static final String TIPTOP = "tipTop";
    private static final String TIPRIGHT = "tipRight";
    private static final String TIPLEFT = "tipLeft";

    public ChargingRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = ctx.bakeLayer(PNCModelLayers.CHARGING_MODULE);
        this.tip = root.getChild(TIP);
        this.body = root.getChild(BODY);
        this.tubeConnector = root.getChild(TUBECONNECTOR);
        this.tipBottom = root.getChild(TIPBOTTOM);
        this.tipTop = root.getChild(TIPTOP);
        this.tipRight = root.getChild(TIPRIGHT);
        this.tipLeft = root.getChild(TIPLEFT);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(TIP, CubeListBuilder.create().texOffs(0, 11).addBox("tip_0", 0.0f, 0.0f, 1.5f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)15.0f, (float)8.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        partdefinition.addOrReplaceChild(BODY, CubeListBuilder.create().texOffs(0, 6).addBox("body_0", 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)1.5f, (float)14.5f, (float)6.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR, CubeListBuilder.create().texOffs(0, 0).addBox("tubeConnector_0", 0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)14.0f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        partdefinition.addOrReplaceChild(TIPBOTTOM, CubeListBuilder.create().texOffs(0, 18).addBox("tipBottom_0", 0.0f, 2.0f, -0.5f, 2.0f, 0.0f, 1.0f), PartPose.offset((float)-1.0f, (float)15.0f, (float)7.0f));
        partdefinition.addOrReplaceChild(TIPTOP, CubeListBuilder.create().texOffs(0, 14).addBox("tipTop_0", 0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f), PartPose.offset((float)-1.0f, (float)15.0f, (float)7.0f));
        partdefinition.addOrReplaceChild(TIPRIGHT, CubeListBuilder.create().texOffs(2, 15).addBox("tipRight_0", 0.0f, -1.0f, -0.5f, 0.0f, 2.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild(TIPLEFT, CubeListBuilder.create().texOffs(0, 15).addBox("tipLeft_0", 0.0f, -1.0f, -0.5f, 0.0f, 2.0f, 1.0f), PartPose.offset((float)1.0f, (float)16.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @Override
    protected void render(ChargingModule module, PoseStack matrixStack, VertexConsumer builder, float partialTicks, int combinedLight, int combinedOverlay, int alpha) {
        int color = FastColor.ARGB32.color((int)alpha, (int)0xFFFFFF);
        this.tip.render(matrixStack, builder, combinedLight, combinedOverlay, color);
        this.body.render(matrixStack, builder, combinedLight, combinedOverlay, color);
        this.tubeConnector.render(matrixStack, builder, combinedLight, combinedOverlay, color);
        this.tipBottom.render(matrixStack, builder, combinedLight, combinedOverlay, color);
        this.tipTop.render(matrixStack, builder, combinedLight, combinedOverlay, color);
        this.tipRight.render(matrixStack, builder, combinedLight, combinedOverlay, color);
        this.tipLeft.render(matrixStack, builder, combinedLight, combinedOverlay, color);
    }

    @Override
    protected ResourceLocation getTexture(boolean isUpgraded) {
        return isUpgraded ? Textures.MODEL_CHARGING_MODULE_UPGRADED : Textures.MODEL_CHARGING_MODULE;
    }
}

